/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoreDevicesResponse extends GreengrassV2Response implements
        ToCopyableBuilder<ListCoreDevicesResponse.Builder, ListCoreDevicesResponse> {
    private static final SdkField<List<CoreDevice>> CORE_DEVICES_FIELD = SdkField
            .<List<CoreDevice>> builder(MarshallingType.LIST)
            .memberName("coreDevices")
            .getter(getter(ListCoreDevicesResponse::coreDevices))
            .setter(setter(Builder::coreDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreDevice> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreDevice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCoreDevicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CoreDevice> coreDevices;

    private final String nextToken;

    private ListCoreDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.coreDevices = builder.coreDevices;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CoreDevices property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCoreDevices() {
        return coreDevices != null && !(coreDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each core device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCoreDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that summarizes each core device.
     */
    public final List<CoreDevice> coreDevices() {
        return coreDevices;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCoreDevices() ? coreDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreDevicesResponse)) {
            return false;
        }
        ListCoreDevicesResponse other = (ListCoreDevicesResponse) obj;
        return hasCoreDevices() == other.hasCoreDevices() && Objects.equals(coreDevices(), other.coreDevices())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCoreDevicesResponse").add("CoreDevices", hasCoreDevices() ? coreDevices() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coreDevices":
            return Optional.ofNullable(clazz.cast(coreDevices()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoreDevicesResponse, T> g) {
        return obj -> g.apply((ListCoreDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListCoreDevicesResponse> {
        /**
         * <p>
         * A list that summarizes each core device.
         * </p>
         * 
         * @param coreDevices
         *        A list that summarizes each core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDevices(Collection<CoreDevice> coreDevices);

        /**
         * <p>
         * A list that summarizes each core device.
         * </p>
         * 
         * @param coreDevices
         *        A list that summarizes each core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDevices(CoreDevice... coreDevices);

        /**
         * <p>
         * A list that summarizes each core device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CoreDevice>.Builder} avoiding the need to
         * create one manually via {@link List<CoreDevice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CoreDevice>.Builder#build()} is called immediately and its
         * result is passed to {@link #coreDevices(List<CoreDevice>)}.
         * 
         * @param coreDevices
         *        a consumer that will call methods on {@link List<CoreDevice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreDevices(List<CoreDevice>)
         */
        Builder coreDevices(Consumer<CoreDevice.Builder>... coreDevices);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private List<CoreDevice> coreDevices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreDevicesResponse model) {
            super(model);
            coreDevices(model.coreDevices);
            nextToken(model.nextToken);
        }

        public final Collection<CoreDevice.Builder> getCoreDevices() {
            if (coreDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return coreDevices != null ? coreDevices.stream().map(CoreDevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder coreDevices(Collection<CoreDevice> coreDevices) {
            this.coreDevices = CoreDevicesListCopier.copy(coreDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreDevices(CoreDevice... coreDevices) {
            coreDevices(Arrays.asList(coreDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreDevices(Consumer<CoreDevice.Builder>... coreDevices) {
            coreDevices(Stream.of(coreDevices).map(c -> CoreDevice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCoreDevices(Collection<CoreDevice.BuilderImpl> coreDevices) {
            this.coreDevices = CoreDevicesListCopier.copyFromBuilder(coreDevices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCoreDevicesResponse build() {
            return new ListCoreDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
