/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentsRequest extends GreengrassV2Request implements
        ToCopyableBuilder<ListComponentsRequest.Builder, ListComponentsRequest> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(ListComponentsRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scope").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListComponentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComponentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String scope;

    private final Integer maxResults;

    private final String nextToken;

    private ListComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scope of the components to list.
     * </p>
     * <p>
     * Default: <code>PRIVATE</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link ComponentVisibilityScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the components to list.</p>
     *         <p>
     *         Default: <code>PRIVATE</code>
     * @see ComponentVisibilityScope
     */
    public final ComponentVisibilityScope scope() {
        return ComponentVisibilityScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the components to list.
     * </p>
     * <p>
     * Default: <code>PRIVATE</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link ComponentVisibilityScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the components to list.</p>
     *         <p>
     *         Default: <code>PRIVATE</code>
     * @see ComponentVisibilityScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The maximum number of results to be returned per paginated request.
     * </p>
     * 
     * @return The maximum number of results to be returned per paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsRequest)) {
            return false;
        }
        ListComponentsRequest other = (ListComponentsRequest) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentsRequest").add("Scope", scopeAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentsRequest, T> g) {
        return obj -> g.apply((ListComponentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListComponentsRequest> {
        /**
         * <p>
         * The scope of the components to list.
         * </p>
         * <p>
         * Default: <code>PRIVATE</code>
         * </p>
         * 
         * @param scope
         *        The scope of the components to list.</p>
         *        <p>
         *        Default: <code>PRIVATE</code>
         * @see ComponentVisibilityScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentVisibilityScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the components to list.
         * </p>
         * <p>
         * Default: <code>PRIVATE</code>
         * </p>
         * 
         * @param scope
         *        The scope of the components to list.</p>
         *        <p>
         *        Default: <code>PRIVATE</code>
         * @see ComponentVisibilityScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentVisibilityScope
         */
        Builder scope(ComponentVisibilityScope scope);

        /**
         * <p>
         * The maximum number of results to be returned per paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private String scope;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentsRequest model) {
            super(model);
            scope(model.scope);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(ComponentVisibilityScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListComponentsRequest build() {
            return new ListComponentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
