/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a deployment job that AWS IoT Greengrass sends to a AWS IoT Greengrass core device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectiveDeployment implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectiveDeployment.Builder, EffectiveDeployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(EffectiveDeployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentName").getter(getter(EffectiveDeployment::deploymentName))
            .setter(setter(Builder::deploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()).build();

    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotJobId").getter(getter(EffectiveDeployment::iotJobId)).setter(setter(Builder::iotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobId").build()).build();

    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotJobArn").getter(getter(EffectiveDeployment::iotJobArn)).setter(setter(Builder::iotJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EffectiveDeployment::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(EffectiveDeployment::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> CORE_DEVICE_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceExecutionStatus").getter(getter(EffectiveDeployment::coreDeviceExecutionStatusAsString))
            .setter(setter(Builder::coreDeviceExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceExecutionStatus").build())
            .build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(EffectiveDeployment::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(EffectiveDeployment::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedTimestamp").getter(getter(EffectiveDeployment::modifiedTimestamp))
            .setter(setter(Builder::modifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            DEPLOYMENT_NAME_FIELD, IOT_JOB_ID_FIELD, IOT_JOB_ARN_FIELD, DESCRIPTION_FIELD, TARGET_ARN_FIELD,
            CORE_DEVICE_EXECUTION_STATUS_FIELD, REASON_FIELD, CREATION_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String deploymentName;

    private final String iotJobId;

    private final String iotJobArn;

    private final String description;

    private final String targetArn;

    private final String coreDeviceExecutionStatus;

    private final String reason;

    private final Instant creationTimestamp;

    private final Instant modifiedTimestamp;

    private EffectiveDeployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.deploymentName = builder.deploymentName;
        this.iotJobId = builder.iotJobId;
        this.iotJobArn = builder.iotJobArn;
        this.description = builder.description;
        this.targetArn = builder.targetArn;
        this.coreDeviceExecutionStatus = builder.coreDeviceExecutionStatus;
        this.reason = builder.reason;
        this.creationTimestamp = builder.creationTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The name of the deployment.
     * </p>
     * <p>
     * You can create deployments without names. If you create a deployment without a name, the AWS IoT Greengrass V2
     * console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>, where
     * <code>targetType</code> and <code>targetName</code> are the type and name of the deployment target.
     * </p>
     * 
     * @return The name of the deployment.</p>
     *         <p>
     *         You can create deployments without names. If you create a deployment without a name, the AWS IoT
     *         Greengrass V2 console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>,
     *         where <code>targetType</code> and <code>targetName</code> are the type and name of the deployment target.
     */
    public final String deploymentName() {
        return deploymentName;
    }

    /**
     * <p>
     * The ID of the AWS IoT job that applies the deployment to target devices.
     * </p>
     * 
     * @return The ID of the AWS IoT job that applies the deployment to target devices.
     */
    public final String iotJobId() {
        return iotJobId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the AWS IoT
     * job that applies the deployment to target devices.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         AWS IoT job that applies the deployment to target devices.
     */
    public final String iotJobArn() {
        return iotJobArn;
    }

    /**
     * <p>
     * The description of the deployment job.
     * </p>
     * 
     * @return The description of the deployment job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target
     * AWS IoT thing or thing group.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         target AWS IoT thing or thing group.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The status of the deployment job on the AWS IoT Greengrass core device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #coreDeviceExecutionStatus} will return {@link EffectiveDeploymentExecutionStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #coreDeviceExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment job on the AWS IoT Greengrass core device.
     * @see EffectiveDeploymentExecutionStatus
     */
    public final EffectiveDeploymentExecutionStatus coreDeviceExecutionStatus() {
        return EffectiveDeploymentExecutionStatus.fromValue(coreDeviceExecutionStatus);
    }

    /**
     * <p>
     * The status of the deployment job on the AWS IoT Greengrass core device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #coreDeviceExecutionStatus} will return {@link EffectiveDeploymentExecutionStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #coreDeviceExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the deployment job on the AWS IoT Greengrass core device.
     * @see EffectiveDeploymentExecutionStatus
     */
    public final String coreDeviceExecutionStatusAsString() {
        return coreDeviceExecutionStatus;
    }

    /**
     * <p>
     * The reason code for the update, if the job was updated.
     * </p>
     * 
     * @return The reason code for the update, if the job was updated.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The time at which the deployment was created, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the deployment was created, expressed in ISO 8601 format.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The time at which the deployment job was last modified, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the deployment job was last modified, expressed in ISO 8601 format.
     */
    public final Instant modifiedTimestamp() {
        return modifiedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveDeployment)) {
            return false;
        }
        EffectiveDeployment other = (EffectiveDeployment) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(deploymentName(), other.deploymentName())
                && Objects.equals(iotJobId(), other.iotJobId()) && Objects.equals(iotJobArn(), other.iotJobArn())
                && Objects.equals(description(), other.description()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(coreDeviceExecutionStatusAsString(), other.coreDeviceExecutionStatusAsString())
                && Objects.equals(reason(), other.reason()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(modifiedTimestamp(), other.modifiedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectiveDeployment").add("DeploymentId", deploymentId())
                .add("DeploymentName", deploymentName()).add("IotJobId", iotJobId()).add("IotJobArn", iotJobArn())
                .add("Description", description()).add("TargetArn", targetArn())
                .add("CoreDeviceExecutionStatus", coreDeviceExecutionStatusAsString()).add("Reason", reason())
                .add("CreationTimestamp", creationTimestamp()).add("ModifiedTimestamp", modifiedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "deploymentName":
            return Optional.ofNullable(clazz.cast(deploymentName()));
        case "iotJobId":
            return Optional.ofNullable(clazz.cast(iotJobId()));
        case "iotJobArn":
            return Optional.ofNullable(clazz.cast(iotJobArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "coreDeviceExecutionStatus":
            return Optional.ofNullable(clazz.cast(coreDeviceExecutionStatusAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "modifiedTimestamp":
            return Optional.ofNullable(clazz.cast(modifiedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveDeployment, T> g) {
        return obj -> g.apply((EffectiveDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectiveDeployment> {
        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The name of the deployment.
         * </p>
         * <p>
         * You can create deployments without names. If you create a deployment without a name, the AWS IoT Greengrass
         * V2 console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>, where
         * <code>targetType</code> and <code>targetName</code> are the type and name of the deployment target.
         * </p>
         * 
         * @param deploymentName
         *        The name of the deployment.</p>
         *        <p>
         *        You can create deployments without names. If you create a deployment without a name, the AWS IoT
         *        Greengrass V2 console shows the deployment name as <code>&lt;targetType&gt;:&lt;targetName&gt;</code>,
         *        where <code>targetType</code> and <code>targetName</code> are the type and name of the deployment
         *        target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentName(String deploymentName);

        /**
         * <p>
         * The ID of the AWS IoT job that applies the deployment to target devices.
         * </p>
         * 
         * @param iotJobId
         *        The ID of the AWS IoT job that applies the deployment to target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobId(String iotJobId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the AWS
         * IoT job that applies the deployment to target devices.
         * </p>
         * 
         * @param iotJobArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the AWS IoT job that applies the deployment to target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobArn(String iotJobArn);

        /**
         * <p>
         * The description of the deployment job.
         * </p>
         * 
         * @param description
         *        The description of the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * target AWS IoT thing or thing group.
         * </p>
         * 
         * @param targetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the target AWS IoT thing or thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The status of the deployment job on the AWS IoT Greengrass core device.
         * </p>
         * 
         * @param coreDeviceExecutionStatus
         *        The status of the deployment job on the AWS IoT Greengrass core device.
         * @see EffectiveDeploymentExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectiveDeploymentExecutionStatus
         */
        Builder coreDeviceExecutionStatus(String coreDeviceExecutionStatus);

        /**
         * <p>
         * The status of the deployment job on the AWS IoT Greengrass core device.
         * </p>
         * 
         * @param coreDeviceExecutionStatus
         *        The status of the deployment job on the AWS IoT Greengrass core device.
         * @see EffectiveDeploymentExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectiveDeploymentExecutionStatus
         */
        Builder coreDeviceExecutionStatus(EffectiveDeploymentExecutionStatus coreDeviceExecutionStatus);

        /**
         * <p>
         * The reason code for the update, if the job was updated.
         * </p>
         * 
         * @param reason
         *        The reason code for the update, if the job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The time at which the deployment was created, expressed in ISO 8601 format.
         * </p>
         * 
         * @param creationTimestamp
         *        The time at which the deployment was created, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The time at which the deployment job was last modified, expressed in ISO 8601 format.
         * </p>
         * 
         * @param modifiedTimestamp
         *        The time at which the deployment job was last modified, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimestamp(Instant modifiedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String deploymentName;

        private String iotJobId;

        private String iotJobArn;

        private String description;

        private String targetArn;

        private String coreDeviceExecutionStatus;

        private String reason;

        private Instant creationTimestamp;

        private Instant modifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveDeployment model) {
            deploymentId(model.deploymentId);
            deploymentName(model.deploymentName);
            iotJobId(model.iotJobId);
            iotJobArn(model.iotJobArn);
            description(model.description);
            targetArn(model.targetArn);
            coreDeviceExecutionStatus(model.coreDeviceExecutionStatus);
            reason(model.reason);
            creationTimestamp(model.creationTimestamp);
            modifiedTimestamp(model.modifiedTimestamp);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDeploymentName() {
            return deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public final String getIotJobId() {
            return iotJobId;
        }

        @Override
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        public final String getIotJobArn() {
            return iotJobArn;
        }

        @Override
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getCoreDeviceExecutionStatus() {
            return coreDeviceExecutionStatus;
        }

        @Override
        public final Builder coreDeviceExecutionStatus(String coreDeviceExecutionStatus) {
            this.coreDeviceExecutionStatus = coreDeviceExecutionStatus;
            return this;
        }

        @Override
        public final Builder coreDeviceExecutionStatus(EffectiveDeploymentExecutionStatus coreDeviceExecutionStatus) {
            this.coreDeviceExecutionStatus(coreDeviceExecutionStatus == null ? null : coreDeviceExecutionStatus.toString());
            return this;
        }

        public final void setCoreDeviceExecutionStatus(String coreDeviceExecutionStatus) {
            this.coreDeviceExecutionStatus = coreDeviceExecutionStatus;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public EffectiveDeployment build() {
            return new EffectiveDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
