/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentResponse extends GreengrassV2Response implements
        ToCopyableBuilder<CreateDeploymentResponse.Builder, CreateDeploymentResponse> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(CreateDeploymentResponse::deploymentId))
            .setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotJobId").getter(getter(CreateDeploymentResponse::iotJobId)).setter(setter(Builder::iotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobId").build()).build();

    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotJobArn").getter(getter(CreateDeploymentResponse::iotJobArn)).setter(setter(Builder::iotJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            IOT_JOB_ID_FIELD, IOT_JOB_ARN_FIELD));

    private final String deploymentId;

    private final String iotJobId;

    private final String iotJobArn;

    private CreateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.iotJobId = builder.iotJobId;
        this.iotJobArn = builder.iotJobArn;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The ID of the AWS IoT job that applies the deployment to target devices.
     * </p>
     * 
     * @return The ID of the AWS IoT job that applies the deployment to target devices.
     */
    public final String iotJobId() {
        return iotJobId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the AWS IoT
     * job that applies the deployment to target devices.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         AWS IoT job that applies the deployment to target devices.
     */
    public final String iotJobArn() {
        return iotJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(iotJobId(), other.iotJobId())
                && Objects.equals(iotJobArn(), other.iotJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentResponse").add("DeploymentId", deploymentId()).add("IotJobId", iotJobId())
                .add("IotJobArn", iotJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "iotJobId":
            return Optional.ofNullable(clazz.cast(iotJobId()));
        case "iotJobArn":
            return Optional.ofNullable(clazz.cast(iotJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentResponse, T> g) {
        return obj -> g.apply((CreateDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentResponse> {
        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The ID of the AWS IoT job that applies the deployment to target devices.
         * </p>
         * 
         * @param iotJobId
         *        The ID of the AWS IoT job that applies the deployment to target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobId(String iotJobId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the AWS
         * IoT job that applies the deployment to target devices.
         * </p>
         * 
         * @param iotJobArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the AWS IoT job that applies the deployment to target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobArn(String iotJobArn);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String deploymentId;

        private String iotJobId;

        private String iotJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            super(model);
            deploymentId(model.deploymentId);
            iotJobId(model.iotJobId);
            iotJobArn(model.iotJobArn);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getIotJobId() {
            return iotJobId;
        }

        @Override
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        public final String getIotJobArn() {
            return iotJobArn;
        }

        @Override
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
