/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentVersionRequest extends GreengrassV2Request implements
        ToCopyableBuilder<CreateComponentVersionRequest.Builder, CreateComponentVersionRequest> {
    private static final SdkField<SdkBytes> INLINE_RECIPE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("inlineRecipe").getter(getter(CreateComponentVersionRequest::inlineRecipe))
            .setter(setter(Builder::inlineRecipe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRecipe").build()).build();

    private static final SdkField<LambdaFunctionRecipeSource> LAMBDA_FUNCTION_FIELD = SdkField
            .<LambdaFunctionRecipeSource> builder(MarshallingType.SDK_POJO).memberName("lambdaFunction")
            .getter(getter(CreateComponentVersionRequest::lambdaFunction)).setter(setter(Builder::lambdaFunction))
            .constructor(LambdaFunctionRecipeSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunction").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateComponentVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_RECIPE_FIELD,
            LAMBDA_FUNCTION_FIELD, TAGS_FIELD));

    private final SdkBytes inlineRecipe;

    private final LambdaFunctionRecipeSource lambdaFunction;

    private final Map<String, String> tags;

    private CreateComponentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.inlineRecipe = builder.inlineRecipe;
        this.lambdaFunction = builder.lambdaFunction;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies,
     * lifecycle, artifacts, and platform compatibility.
     * </p>
     * <p>
     * You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
     * </p>
     * 
     * @return The recipe to use to create the component. The recipe defines the component's metadata, parameters,
     *         dependencies, lifecycle, artifacts, and platform compatibility.</p>
     *         <p>
     *         You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
     */
    public final SdkBytes inlineRecipe() {
        return inlineRecipe;
    }

    /**
     * <p>
     * The parameters to create a component from a Lambda function.
     * </p>
     * <p>
     * You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
     * </p>
     * 
     * @return The parameters to create a component from a Lambda function.</p>
     *         <p>
     *         You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
     */
    public final LambdaFunctionRecipeSource lambdaFunction() {
        return lambdaFunction;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the resource. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the
     * <i>AWS IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a>
     *         in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inlineRecipe());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentVersionRequest)) {
            return false;
        }
        CreateComponentVersionRequest other = (CreateComponentVersionRequest) obj;
        return Objects.equals(inlineRecipe(), other.inlineRecipe()) && Objects.equals(lambdaFunction(), other.lambdaFunction())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComponentVersionRequest").add("InlineRecipe", inlineRecipe())
                .add("LambdaFunction", lambdaFunction()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inlineRecipe":
            return Optional.ofNullable(clazz.cast(inlineRecipe()));
        case "lambdaFunction":
            return Optional.ofNullable(clazz.cast(lambdaFunction()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentVersionRequest, T> g) {
        return obj -> g.apply((CreateComponentVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateComponentVersionRequest> {
        /**
         * <p>
         * The recipe to use to create the component. The recipe defines the component's metadata, parameters,
         * dependencies, lifecycle, artifacts, and platform compatibility.
         * </p>
         * <p>
         * You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
         * </p>
         * 
         * @param inlineRecipe
         *        The recipe to use to create the component. The recipe defines the component's metadata, parameters,
         *        dependencies, lifecycle, artifacts, and platform compatibility.</p>
         *        <p>
         *        You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineRecipe(SdkBytes inlineRecipe);

        /**
         * <p>
         * The parameters to create a component from a Lambda function.
         * </p>
         * <p>
         * You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
         * </p>
         * 
         * @param lambdaFunction
         *        The parameters to create a component from a Lambda function.</p>
         *        <p>
         *        You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunction(LambdaFunctionRecipeSource lambdaFunction);

        /**
         * <p>
         * The parameters to create a component from a Lambda function.
         * </p>
         * <p>
         * You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaFunctionRecipeSource.Builder} avoiding the
         * need to create one manually via {@link LambdaFunctionRecipeSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionRecipeSource.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaFunction(LambdaFunctionRecipeSource)}.
         * 
         * @param lambdaFunction
         *        a consumer that will call methods on {@link LambdaFunctionRecipeSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunction(LambdaFunctionRecipeSource)
         */
        default Builder lambdaFunction(Consumer<LambdaFunctionRecipeSource.Builder> lambdaFunction) {
            return lambdaFunction(LambdaFunctionRecipeSource.builder().applyMutation(lambdaFunction).build());
        }

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the resource. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in
         * the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         *        resources</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassV2Request.BuilderImpl implements Builder {
        private SdkBytes inlineRecipe;

        private LambdaFunctionRecipeSource lambdaFunction;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentVersionRequest model) {
            super(model);
            inlineRecipe(model.inlineRecipe);
            lambdaFunction(model.lambdaFunction);
            tags(model.tags);
        }

        public final ByteBuffer getInlineRecipe() {
            return inlineRecipe == null ? null : inlineRecipe.asByteBuffer();
        }

        @Override
        public final Builder inlineRecipe(SdkBytes inlineRecipe) {
            this.inlineRecipe = StandardMemberCopier.copy(inlineRecipe);
            return this;
        }

        public final void setInlineRecipe(ByteBuffer inlineRecipe) {
            inlineRecipe(inlineRecipe == null ? null : SdkBytes.fromByteBuffer(inlineRecipe));
        }

        public final LambdaFunctionRecipeSource.Builder getLambdaFunction() {
            return lambdaFunction != null ? lambdaFunction.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunction(LambdaFunctionRecipeSource lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        public final void setLambdaFunction(LambdaFunctionRecipeSource.BuilderImpl lambdaFunction) {
            this.lambdaFunction = lambdaFunction != null ? lambdaFunction.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentVersionRequest build() {
            return new CreateComponentVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
