/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a AWS IoT Greengrass core device, which is an AWS IoT thing that runs the AWS IoT
 * Greengrass Core software.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreDevice implements SdkPojo, Serializable, ToCopyableBuilder<CoreDevice.Builder, CoreDevice> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceThingName").getter(getter(CoreDevice::coreDeviceThingName))
            .setter(setter(Builder::coreDeviceThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceThingName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CoreDevice::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastStatusUpdateTimestamp")
            .getter(getter(CoreDevice::lastStatusUpdateTimestamp)).setter(setter(Builder::lastStatusUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusUpdateTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD,
            STATUS_FIELD, LAST_STATUS_UPDATE_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String coreDeviceThingName;

    private final String status;

    private final Instant lastStatusUpdateTimestamp;

    private CoreDevice(BuilderImpl builder) {
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.status = builder.status;
        this.lastStatusUpdateTimestamp = builder.lastStatusUpdateTimestamp;
    }

    /**
     * <p>
     * The name of the core device. This is also the name of the AWS IoT thing.
     * </p>
     * 
     * @return The name of the core device. This is also the name of the AWS IoT thing.
     */
    public final String coreDeviceThingName() {
        return coreDeviceThingName;
    }

    /**
     * <p>
     * The status of the core device. Core devices can have the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device without
     * issue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on the core
     * device.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CoreDeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the core device. Core devices can have the following statuses:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device
     *         without issue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on the
     *         core device.
     *         </p>
     *         </li>
     * @see CoreDeviceStatus
     */
    public final CoreDeviceStatus status() {
        return CoreDeviceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the core device. Core devices can have the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device without
     * issue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on the core
     * device.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CoreDeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the core device. Core devices can have the following statuses:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device
     *         without issue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on the
     *         core device.
     *         </p>
     *         </li>
     * @see CoreDeviceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the core device's status last updated, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the core device's status last updated, expressed in ISO 8601 format.
     */
    public final Instant lastStatusUpdateTimestamp() {
        return lastStatusUpdateTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusUpdateTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreDevice)) {
            return false;
        }
        CoreDevice other = (CoreDevice) obj;
        return Objects.equals(coreDeviceThingName(), other.coreDeviceThingName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastStatusUpdateTimestamp(), other.lastStatusUpdateTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreDevice").add("CoreDeviceThingName", coreDeviceThingName()).add("Status", statusAsString())
                .add("LastStatusUpdateTimestamp", lastStatusUpdateTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coreDeviceThingName":
            return Optional.ofNullable(clazz.cast(coreDeviceThingName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastStatusUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastStatusUpdateTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreDevice, T> g) {
        return obj -> g.apply((CoreDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreDevice> {
        /**
         * <p>
         * The name of the core device. This is also the name of the AWS IoT thing.
         * </p>
         * 
         * @param coreDeviceThingName
         *        The name of the core device. This is also the name of the AWS IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDeviceThingName(String coreDeviceThingName);

        /**
         * <p>
         * The status of the core device. Core devices can have the following statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device without
         * issue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on the core
         * device.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the core device. Core devices can have the following statuses:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device
         *        without issue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on
         *        the core device.
         *        </p>
         *        </li>
         * @see CoreDeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreDeviceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the core device. Core devices can have the following statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device without
         * issue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on the core
         * device.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the core device. Core devices can have the following statuses:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> – The AWS IoT Greengrass Core software and all components run on the core device
         *        without issue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code> – The AWS IoT Greengrass Core software or a component is in a failed state on
         *        the core device.
         *        </p>
         *        </li>
         * @see CoreDeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreDeviceStatus
         */
        Builder status(CoreDeviceStatus status);

        /**
         * <p>
         * The time at which the core device's status last updated, expressed in ISO 8601 format.
         * </p>
         * 
         * @param lastStatusUpdateTimestamp
         *        The time at which the core device's status last updated, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String coreDeviceThingName;

        private String status;

        private Instant lastStatusUpdateTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreDevice model) {
            coreDeviceThingName(model.coreDeviceThingName);
            status(model.status);
            lastStatusUpdateTimestamp(model.lastStatusUpdateTimestamp);
        }

        public final String getCoreDeviceThingName() {
            return coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CoreDeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastStatusUpdateTimestamp() {
            return lastStatusUpdateTimestamp;
        }

        @Override
        public final Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
            return this;
        }

        public final void setLastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
        }

        @Override
        public CoreDevice build() {
            return new CoreDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
