/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information system user and group that the AWS IoT Greengrass Core software uses to run component processes
 * on the core device. For more information, see <a href=
 * "https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user"
 * >Configure the user and group that run components</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentRunWith implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentRunWith.Builder, ComponentRunWith> {
    private static final SdkField<String> POSIX_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("posixUser").getter(getter(ComponentRunWith::posixUser)).setter(setter(Builder::posixUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("posixUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSIX_USER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String posixUser;

    private ComponentRunWith(BuilderImpl builder) {
        this.posixUser = builder.posixUser;
    }

    /**
     * <p>
     * The POSIX system user and (optional) group to use to run this component. Specify the user and group separated by
     * a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is optional. If you don't
     * specify a group, the AWS IoT Greengrass Core software uses the primary user for the group.
     * </p>
     * 
     * @return The POSIX system user and (optional) group to use to run this component. Specify the user and group
     *         separated by a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is
     *         optional. If you don't specify a group, the AWS IoT Greengrass Core software uses the primary user for
     *         the group.
     */
    public final String posixUser() {
        return posixUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(posixUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRunWith)) {
            return false;
        }
        ComponentRunWith other = (ComponentRunWith) obj;
        return Objects.equals(posixUser(), other.posixUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentRunWith").add("PosixUser", posixUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "posixUser":
            return Optional.ofNullable(clazz.cast(posixUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentRunWith, T> g) {
        return obj -> g.apply((ComponentRunWith) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentRunWith> {
        /**
         * <p>
         * The POSIX system user and (optional) group to use to run this component. Specify the user and group separated
         * by a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is optional. If you
         * don't specify a group, the AWS IoT Greengrass Core software uses the primary user for the group.
         * </p>
         * 
         * @param posixUser
         *        The POSIX system user and (optional) group to use to run this component. Specify the user and group
         *        separated by a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is
         *        optional. If you don't specify a group, the AWS IoT Greengrass Core software uses the primary user for
         *        the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixUser(String posixUser);
    }

    static final class BuilderImpl implements Builder {
        private String posixUser;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentRunWith model) {
            posixUser(model.posixUser);
        }

        public final String getPosixUser() {
            return posixUser;
        }

        @Override
        public final Builder posixUser(String posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final void setPosixUser(String posixUser) {
            this.posixUser = posixUser;
        }

        @Override
        public ComponentRunWith build() {
            return new ComponentRunWith(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
