/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a deployment's update to a component's configuration on Greengrass core devices. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
 * configurations</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentConfigurationUpdate.Builder, ComponentConfigurationUpdate> {
    private static final SdkField<String> MERGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("merge")
            .getter(getter(ComponentConfigurationUpdate::merge)).setter(setter(Builder::merge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("merge").build()).build();

    private static final SdkField<List<String>> RESET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("reset")
            .getter(getter(ComponentConfigurationUpdate::reset))
            .setter(setter(Builder::reset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reset").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_FIELD, RESET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String merge;

    private final List<String> reset;

    private ComponentConfigurationUpdate(BuilderImpl builder) {
        this.merge = builder.merge;
        this.reset = builder.reset;
    }

    /**
     * <p>
     * A serialized JSON string that contains the configuration object to merge to target devices. The core device
     * merges this configuration with the component's existing configuration. If this is the first time a component
     * deploys on a device, the core device merges this configuration with the component's default configuration. This
     * means that the core device keeps it's existing configuration for keys and values that you don't specify in this
     * object. For more information, see <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update"
     * >Merge configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * 
     * @return A serialized JSON string that contains the configuration object to merge to target devices. The core
     *         device merges this configuration with the component's existing configuration. If this is the first time a
     *         component deploys on a device, the core device merges this configuration with the component's default
     *         configuration. This means that the core device keeps it's existing configuration for keys and values that
     *         you don't specify in this object. For more information, see <a href=
     *         "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update"
     *         >Merge configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
     */
    public final String merge() {
        return merge;
    }

    /**
     * Returns true if the Reset property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReset() {
        return reset != null && !(reset instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of configuration nodes to reset to default values on target devices. Use JSON pointers to specify each
     * node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward slashes to separate the
     * key for each level in the object. For more information, see the <a
     * href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update"
     * >Reset configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReset()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of configuration nodes to reset to default values on target devices. Use JSON pointers to
     *         specify each node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward
     *         slashes to separate the key for each level in the object. For more information, see the <a
     *         href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href=
     *         "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update"
     *         >Reset configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
     */
    public final List<String> reset() {
        return reset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(merge());
        hashCode = 31 * hashCode + Objects.hashCode(hasReset() ? reset() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentConfigurationUpdate)) {
            return false;
        }
        ComponentConfigurationUpdate other = (ComponentConfigurationUpdate) obj;
        return Objects.equals(merge(), other.merge()) && hasReset() == other.hasReset() && Objects.equals(reset(), other.reset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentConfigurationUpdate").add("Merge", merge()).add("Reset", hasReset() ? reset() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "merge":
            return Optional.ofNullable(clazz.cast(merge()));
        case "reset":
            return Optional.ofNullable(clazz.cast(reset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentConfigurationUpdate, T> g) {
        return obj -> g.apply((ComponentConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentConfigurationUpdate> {
        /**
         * <p>
         * A serialized JSON string that contains the configuration object to merge to target devices. The core device
         * merges this configuration with the component's existing configuration. If this is the first time a component
         * deploys on a device, the core device merges this configuration with the component's default configuration.
         * This means that the core device keeps it's existing configuration for keys and values that you don't specify
         * in this object. For more information, see <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update"
         * >Merge configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param merge
         *        A serialized JSON string that contains the configuration object to merge to target devices. The core
         *        device merges this configuration with the component's existing configuration. If this is the first
         *        time a component deploys on a device, the core device merges this configuration with the component's
         *        default configuration. This means that the core device keeps it's existing configuration for keys and
         *        values that you don't specify in this object. For more information, see <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update"
         *        >Merge configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder merge(String merge);

        /**
         * <p>
         * The list of configuration nodes to reset to default values on target devices. Use JSON pointers to specify
         * each node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward slashes to
         * separate the key for each level in the object. For more information, see the <a
         * href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update"
         * >Reset configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param reset
         *        The list of configuration nodes to reset to default values on target devices. Use JSON pointers to
         *        specify each node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward
         *        slashes to separate the key for each level in the object. For more information, see the <a
         *        href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update"
         *        >Reset configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reset(Collection<String> reset);

        /**
         * <p>
         * The list of configuration nodes to reset to default values on target devices. Use JSON pointers to specify
         * each node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward slashes to
         * separate the key for each level in the object. For more information, see the <a
         * href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href=
         * "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update"
         * >Reset configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param reset
         *        The list of configuration nodes to reset to default values on target devices. Use JSON pointers to
         *        specify each node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward
         *        slashes to separate the key for each level in the object. For more information, see the <a
         *        href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href=
         *        "https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update"
         *        >Reset configuration updates</a> in the <i>AWS IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reset(String... reset);
    }

    static final class BuilderImpl implements Builder {
        private String merge;

        private List<String> reset = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentConfigurationUpdate model) {
            merge(model.merge);
            reset(model.reset);
        }

        public final String getMerge() {
            return merge;
        }

        @Override
        public final Builder merge(String merge) {
            this.merge = merge;
            return this;
        }

        public final void setMerge(String merge) {
            this.merge = merge;
        }

        public final Collection<String> getReset() {
            if (reset instanceof SdkAutoConstructList) {
                return null;
            }
            return reset;
        }

        @Override
        public final Builder reset(Collection<String> reset) {
            this.reset = ComponentConfigurationPathListCopier.copy(reset);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reset(String... reset) {
            reset(Arrays.asList(reset));
            return this;
        }

        public final void setReset(Collection<String> reset) {
            this.reset = ComponentConfigurationPathListCopier.copy(reset);
        }

        @Override
        public ComponentConfigurationUpdate build() {
            return new ComponentConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
