/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Component implements SdkPojo, Serializable, ToCopyableBuilder<Component.Builder, Component> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Component::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(Component::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<ComponentLatestVersion> LATEST_VERSION_FIELD = SdkField
            .<ComponentLatestVersion> builder(MarshallingType.SDK_POJO).memberName("latestVersion")
            .getter(getter(Component::latestVersion)).setter(setter(Builder::latestVersion))
            .constructor(ComponentLatestVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPONENT_NAME_FIELD, LATEST_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String componentName;

    private final ComponentLatestVersion latestVersion;

    private Component(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.latestVersion = builder.latestVersion;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         component version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The latest version of the component and its details.
     * </p>
     * 
     * @return The latest version of the component and its details.
     */
    public final ComponentLatestVersion latestVersion() {
        return latestVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(componentName(), other.componentName())
                && Objects.equals(latestVersion(), other.latestVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Component").add("Arn", arn()).add("ComponentName", componentName())
                .add("LatestVersion", latestVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Component, T> g) {
        return obj -> g.apply((Component) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Component> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * component version.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The latest version of the component and its details.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the component and its details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(ComponentLatestVersion latestVersion);

        /**
         * <p>
         * The latest version of the component and its details.
         * </p>
         * This is a convenience that creates an instance of the {@link ComponentLatestVersion.Builder} avoiding the
         * need to create one manually via {@link ComponentLatestVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComponentLatestVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #latestVersion(ComponentLatestVersion)}.
         * 
         * @param latestVersion
         *        a consumer that will call methods on {@link ComponentLatestVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestVersion(ComponentLatestVersion)
         */
        default Builder latestVersion(Consumer<ComponentLatestVersion.Builder> latestVersion) {
            return latestVersion(ComponentLatestVersion.builder().applyMutation(latestVersion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String componentName;

        private ComponentLatestVersion latestVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Component model) {
            arn(model.arn);
            componentName(model.componentName);
            latestVersion(model.latestVersion);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getComponentName() {
            return componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final ComponentLatestVersion.Builder getLatestVersion() {
            return latestVersion != null ? latestVersion.toBuilder() : null;
        }

        @Override
        public final Builder latestVersion(ComponentLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(ComponentLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public Component build() {
            return new Component(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
