/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDependencyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentDependencyRequirement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentDependencyRequirement> {
    private static final SdkField<String> VERSION_REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionRequirement").getter(ComponentDependencyRequirement.getter(ComponentDependencyRequirement::versionRequirement)).setter(ComponentDependencyRequirement.setter(Builder::versionRequirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRequirement").build()}).build();
    private static final SdkField<String> DEPENDENCY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dependencyType").getter(ComponentDependencyRequirement.getter(ComponentDependencyRequirement::dependencyTypeAsString)).setter(ComponentDependencyRequirement.setter(Builder::dependencyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_REQUIREMENT_FIELD, DEPENDENCY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String versionRequirement;
    private final String dependencyType;

    private ComponentDependencyRequirement(BuilderImpl builder) {
        this.versionRequirement = builder.versionRequirement;
        this.dependencyType = builder.dependencyType;
    }

    public String versionRequirement() {
        return this.versionRequirement;
    }

    public ComponentDependencyType dependencyType() {
        return ComponentDependencyType.fromValue(this.dependencyType);
    }

    public String dependencyTypeAsString() {
        return this.dependencyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionRequirement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentDependencyRequirement)) {
            return false;
        }
        ComponentDependencyRequirement other = (ComponentDependencyRequirement)obj;
        return Objects.equals(this.versionRequirement(), other.versionRequirement()) && Objects.equals(this.dependencyTypeAsString(), other.dependencyTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ComponentDependencyRequirement").add("VersionRequirement", (Object)this.versionRequirement()).add("DependencyType", (Object)this.dependencyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "versionRequirement": {
                return Optional.ofNullable(clazz.cast(this.versionRequirement()));
            }
            case "dependencyType": {
                return Optional.ofNullable(clazz.cast(this.dependencyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentDependencyRequirement, T> g) {
        return obj -> g.apply((ComponentDependencyRequirement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String versionRequirement;
        private String dependencyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentDependencyRequirement model) {
            this.versionRequirement(model.versionRequirement);
            this.dependencyType(model.dependencyType);
        }

        public final String getVersionRequirement() {
            return this.versionRequirement;
        }

        @Override
        public final Builder versionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
            return this;
        }

        public final void setVersionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
        }

        public final String getDependencyType() {
            return this.dependencyType;
        }

        @Override
        public final Builder dependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
            return this;
        }

        @Override
        public final Builder dependencyType(ComponentDependencyType dependencyType) {
            this.dependencyType(dependencyType == null ? null : dependencyType.toString());
            return this;
        }

        public final void setDependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
        }

        public ComponentDependencyRequirement build() {
            return new ComponentDependencyRequirement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentDependencyRequirement> {
        public Builder versionRequirement(String var1);

        public Builder dependencyType(String var1);

        public Builder dependencyType(ComponentDependencyType var1);
    }
}

