/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.ComponentConfigurationPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentConfigurationUpdate> {
    private static final SdkField<String> MERGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("merge").getter(ComponentConfigurationUpdate.getter(ComponentConfigurationUpdate::merge)).setter(ComponentConfigurationUpdate.setter(Builder::merge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("merge").build()}).build();
    private static final SdkField<List<String>> RESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reset").getter(ComponentConfigurationUpdate.getter(ComponentConfigurationUpdate::reset)).setter(ComponentConfigurationUpdate.setter(Builder::reset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reset").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_FIELD, RESET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String merge;
    private final List<String> reset;

    private ComponentConfigurationUpdate(BuilderImpl builder) {
        this.merge = builder.merge;
        this.reset = builder.reset;
    }

    public String merge() {
        return this.merge;
    }

    public boolean hasReset() {
        return this.reset != null && !(this.reset instanceof SdkAutoConstructList);
    }

    public List<String> reset() {
        return this.reset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.merge());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReset() ? this.reset() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentConfigurationUpdate)) {
            return false;
        }
        ComponentConfigurationUpdate other = (ComponentConfigurationUpdate)obj;
        return Objects.equals(this.merge(), other.merge()) && this.hasReset() == other.hasReset() && Objects.equals(this.reset(), other.reset());
    }

    public String toString() {
        return ToString.builder((String)"ComponentConfigurationUpdate").add("Merge", (Object)this.merge()).add("Reset", this.hasReset() ? this.reset() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "merge": {
                return Optional.ofNullable(clazz.cast(this.merge()));
            }
            case "reset": {
                return Optional.ofNullable(clazz.cast(this.reset()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentConfigurationUpdate, T> g) {
        return obj -> g.apply((ComponentConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String merge;
        private List<String> reset = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentConfigurationUpdate model) {
            this.merge(model.merge);
            this.reset(model.reset);
        }

        public final String getMerge() {
            return this.merge;
        }

        @Override
        public final Builder merge(String merge) {
            this.merge = merge;
            return this;
        }

        public final void setMerge(String merge) {
            this.merge = merge;
        }

        public final Collection<String> getReset() {
            if (this.reset instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reset;
        }

        @Override
        public final Builder reset(Collection<String> reset) {
            this.reset = ComponentConfigurationPathListCopier.copy(reset);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reset(String ... reset) {
            this.reset(Arrays.asList(reset));
            return this;
        }

        public final void setReset(Collection<String> reset) {
            this.reset = ComponentConfigurationPathListCopier.copy(reset);
        }

        public ComponentConfigurationUpdate build() {
            return new ComponentConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentConfigurationUpdate> {
        public Builder merge(String var1);

        public Builder reset(Collection<String> var1);

        public Builder reset(String ... var1);
    }
}

