/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDeploymentSpecification;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDeploymentSpecificationsCopier;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentIoTJobConfiguration;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentPolicies;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Request;
import software.amazon.awssdk.services.greengrassv2.model.TagMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends GreengrassV2Request
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::targetArn)).setter(CreateDeploymentRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::deploymentName)).setter(CreateDeploymentRequest.setter(Builder::deploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()}).build();
    private static final SdkField<Map<String, ComponentDeploymentSpecification>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("components").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::components)).setter(CreateDeploymentRequest.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentDeploymentSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DeploymentIoTJobConfiguration> IOT_JOB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotJobConfiguration").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::iotJobConfiguration)).setter(CreateDeploymentRequest.setter(Builder::iotJobConfiguration)).constructor(DeploymentIoTJobConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobConfiguration").build()}).build();
    private static final SdkField<DeploymentPolicies> DEPLOYMENT_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentPolicies").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::deploymentPolicies)).setter(CreateDeploymentRequest.setter(Builder::deploymentPolicies)).constructor(DeploymentPolicies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPolicies").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::tags)).setter(CreateDeploymentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, DEPLOYMENT_NAME_FIELD, COMPONENTS_FIELD, IOT_JOB_CONFIGURATION_FIELD, DEPLOYMENT_POLICIES_FIELD, TAGS_FIELD));
    private final String targetArn;
    private final String deploymentName;
    private final Map<String, ComponentDeploymentSpecification> components;
    private final DeploymentIoTJobConfiguration iotJobConfiguration;
    private final DeploymentPolicies deploymentPolicies;
    private final Map<String, String> tags;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.deploymentName = builder.deploymentName;
        this.components = builder.components;
        this.iotJobConfiguration = builder.iotJobConfiguration;
        this.deploymentPolicies = builder.deploymentPolicies;
        this.tags = builder.tags;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String deploymentName() {
        return this.deploymentName;
    }

    public boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructMap);
    }

    public Map<String, ComponentDeploymentSpecification> components() {
        return this.components;
    }

    public DeploymentIoTJobConfiguration iotJobConfiguration() {
        return this.iotJobConfiguration;
    }

    public DeploymentPolicies deploymentPolicies() {
        return this.deploymentPolicies;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.deploymentName(), other.deploymentName()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.iotJobConfiguration(), other.iotJobConfiguration()) && Objects.equals(this.deploymentPolicies(), other.deploymentPolicies()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("TargetArn", (Object)this.targetArn()).add("DeploymentName", (Object)this.deploymentName()).add("Components", this.hasComponents() ? this.components() : null).add("IotJobConfiguration", (Object)this.iotJobConfiguration()).add("DeploymentPolicies", (Object)this.deploymentPolicies()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "deploymentName": {
                return Optional.ofNullable(clazz.cast(this.deploymentName()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "iotJobConfiguration": {
                return Optional.ofNullable(clazz.cast(this.iotJobConfiguration()));
            }
            case "deploymentPolicies": {
                return Optional.ofNullable(clazz.cast(this.deploymentPolicies()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Request.BuilderImpl
    implements Builder {
        private String targetArn;
        private String deploymentName;
        private Map<String, ComponentDeploymentSpecification> components = DefaultSdkAutoConstructMap.getInstance();
        private DeploymentIoTJobConfiguration iotJobConfiguration;
        private DeploymentPolicies deploymentPolicies;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.targetArn(model.targetArn);
            this.deploymentName(model.deploymentName);
            this.components(model.components);
            this.iotJobConfiguration(model.iotJobConfiguration);
            this.deploymentPolicies(model.deploymentPolicies);
            this.tags(model.tags);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getDeploymentName() {
            return this.deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public final Map<String, ComponentDeploymentSpecification.Builder> getComponents() {
            if (this.components instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.components != null ? CollectionUtils.mapValues(this.components, ComponentDeploymentSpecification::toBuilder) : null;
        }

        @Override
        public final Builder components(Map<String, ComponentDeploymentSpecification> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copy(components);
            return this;
        }

        public final void setComponents(Map<String, ComponentDeploymentSpecification.BuilderImpl> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copyFromBuilder(components);
        }

        public final DeploymentIoTJobConfiguration.Builder getIotJobConfiguration() {
            return this.iotJobConfiguration != null ? this.iotJobConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder iotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration;
            return this;
        }

        public final void setIotJobConfiguration(DeploymentIoTJobConfiguration.BuilderImpl iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration != null ? iotJobConfiguration.build() : null;
        }

        public final DeploymentPolicies.Builder getDeploymentPolicies() {
            return this.deploymentPolicies != null ? this.deploymentPolicies.toBuilder() : null;
        }

        @Override
        public final Builder deploymentPolicies(DeploymentPolicies deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies;
            return this;
        }

        public final void setDeploymentPolicies(DeploymentPolicies.BuilderImpl deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies != null ? deploymentPolicies.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder targetArn(String var1);

        public Builder deploymentName(String var1);

        public Builder components(Map<String, ComponentDeploymentSpecification> var1);

        public Builder iotJobConfiguration(DeploymentIoTJobConfiguration var1);

        default public Builder iotJobConfiguration(Consumer<DeploymentIoTJobConfiguration.Builder> iotJobConfiguration) {
            return this.iotJobConfiguration((DeploymentIoTJobConfiguration)((DeploymentIoTJobConfiguration.Builder)DeploymentIoTJobConfiguration.builder().applyMutation(iotJobConfiguration)).build());
        }

        public Builder deploymentPolicies(DeploymentPolicies var1);

        default public Builder deploymentPolicies(Consumer<DeploymentPolicies.Builder> deploymentPolicies) {
            return this.deploymentPolicies((DeploymentPolicies)((DeploymentPolicies.Builder)DeploymentPolicies.builder().applyMutation(deploymentPolicies)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

