/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.GroupInformation;
import software.amazon.awssdk.services.greengrass.model.___listOfGroupInformationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListGroupsResponse> {
    private static final SdkField<List<GroupInformation>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListGroupsResponse.getter(ListGroupsResponse::groups)).setter(ListGroupsResponse.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListGroupsResponse.getter(ListGroupsResponse::nextToken)).setter(ListGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GroupInformation> groups;
    private final String nextToken;

    private ListGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.nextToken = builder.nextToken;
    }

    public List<GroupInformation> groups() {
        return this.groups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResponse)) {
            return false;
        }
        ListGroupsResponse other = (ListGroupsResponse)((Object)obj);
        return Objects.equals(this.groups(), other.groups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGroupsResponse").add("Groups", this.groups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsResponse, T> g) {
        return obj -> g.apply((ListGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<GroupInformation> groups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsResponse model) {
            super(model);
            this.groups(model.groups);
            this.nextToken(model.nextToken);
        }

        public final Collection<GroupInformation.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupInformation> groups) {
            this.groups = ___listOfGroupInformationCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupInformation ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupInformation.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupInformation)((GroupInformation.Builder)GroupInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupInformation.BuilderImpl> groups) {
            this.groups = ___listOfGroupInformationCopier.copyFromBuilder(groups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGroupsResponse build() {
            return new ListGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupsResponse> {
        public Builder groups(Collection<GroupInformation> var1);

        public Builder groups(GroupInformation ... var1);

        public Builder groups(Consumer<GroupInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

