/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.EncodingType;
import software.amazon.awssdk.services.greengrass.model.FunctionConfigurationEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionConfiguration> {
    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncodingType").getter(FunctionConfiguration.getter(FunctionConfiguration::encodingTypeAsString)).setter(FunctionConfiguration.setter(Builder::encodingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType").build()}).build();
    private static final SdkField<FunctionConfigurationEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(FunctionConfiguration.getter(FunctionConfiguration::environment)).setter(FunctionConfiguration.setter(Builder::environment)).constructor(FunctionConfigurationEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> EXEC_ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecArgs").getter(FunctionConfiguration.getter(FunctionConfiguration::execArgs)).setter(FunctionConfiguration.setter(Builder::execArgs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecArgs").build()}).build();
    private static final SdkField<String> EXECUTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Executable").getter(FunctionConfiguration.getter(FunctionConfiguration::executable)).setter(FunctionConfiguration.setter(Builder::executable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Executable").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySize").getter(FunctionConfiguration.getter(FunctionConfiguration::memorySize)).setter(FunctionConfiguration.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<Boolean> PINNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Pinned").getter(FunctionConfiguration.getter(FunctionConfiguration::pinned)).setter(FunctionConfiguration.setter(Builder::pinned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pinned").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(FunctionConfiguration.getter(FunctionConfiguration::timeout)).setter(FunctionConfiguration.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<String> FUNCTION_RUNTIME_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionRuntimeOverride").getter(FunctionConfiguration.getter(FunctionConfiguration::functionRuntimeOverride)).setter(FunctionConfiguration.setter(Builder::functionRuntimeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionRuntimeOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_TYPE_FIELD, ENVIRONMENT_FIELD, EXEC_ARGS_FIELD, EXECUTABLE_FIELD, MEMORY_SIZE_FIELD, PINNED_FIELD, TIMEOUT_FIELD, FUNCTION_RUNTIME_OVERRIDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encodingType;
    private final FunctionConfigurationEnvironment environment;
    private final String execArgs;
    private final String executable;
    private final Integer memorySize;
    private final Boolean pinned;
    private final Integer timeout;
    private final String functionRuntimeOverride;

    private FunctionConfiguration(BuilderImpl builder) {
        this.encodingType = builder.encodingType;
        this.environment = builder.environment;
        this.execArgs = builder.execArgs;
        this.executable = builder.executable;
        this.memorySize = builder.memorySize;
        this.pinned = builder.pinned;
        this.timeout = builder.timeout;
        this.functionRuntimeOverride = builder.functionRuntimeOverride;
    }

    public final EncodingType encodingType() {
        return EncodingType.fromValue(this.encodingType);
    }

    public final String encodingTypeAsString() {
        return this.encodingType;
    }

    public final FunctionConfigurationEnvironment environment() {
        return this.environment;
    }

    public final String execArgs() {
        return this.execArgs;
    }

    public final String executable() {
        return this.executable;
    }

    public final Integer memorySize() {
        return this.memorySize;
    }

    public final Boolean pinned() {
        return this.pinned;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final String functionRuntimeOverride() {
        return this.functionRuntimeOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.execArgs());
        hashCode = 31 * hashCode + Objects.hashCode(this.executable());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinned());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionRuntimeOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfiguration)) {
            return false;
        }
        FunctionConfiguration other = (FunctionConfiguration)obj;
        return Objects.equals(this.encodingTypeAsString(), other.encodingTypeAsString()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.execArgs(), other.execArgs()) && Objects.equals(this.executable(), other.executable()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.pinned(), other.pinned()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.functionRuntimeOverride(), other.functionRuntimeOverride());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionConfiguration").add("EncodingType", (Object)this.encodingTypeAsString()).add("Environment", (Object)this.environment()).add("ExecArgs", (Object)this.execArgs()).add("Executable", (Object)this.executable()).add("MemorySize", (Object)this.memorySize()).add("Pinned", (Object)this.pinned()).add("Timeout", (Object)this.timeout()).add("FunctionRuntimeOverride", (Object)this.functionRuntimeOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncodingType": {
                return Optional.ofNullable(clazz.cast(this.encodingTypeAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "ExecArgs": {
                return Optional.ofNullable(clazz.cast(this.execArgs()));
            }
            case "Executable": {
                return Optional.ofNullable(clazz.cast(this.executable()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "Pinned": {
                return Optional.ofNullable(clazz.cast(this.pinned()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "FunctionRuntimeOverride": {
                return Optional.ofNullable(clazz.cast(this.functionRuntimeOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfiguration, T> g) {
        return obj -> g.apply((FunctionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encodingType;
        private FunctionConfigurationEnvironment environment;
        private String execArgs;
        private String executable;
        private Integer memorySize;
        private Boolean pinned;
        private Integer timeout;
        private String functionRuntimeOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfiguration model) {
            this.encodingType(model.encodingType);
            this.environment(model.environment);
            this.execArgs(model.execArgs);
            this.executable(model.executable);
            this.memorySize(model.memorySize);
            this.pinned(model.pinned);
            this.timeout(model.timeout);
            this.functionRuntimeOverride(model.functionRuntimeOverride);
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType == null ? null : encodingType.toString());
            return this;
        }

        public final FunctionConfigurationEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(FunctionConfigurationEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(FunctionConfigurationEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getExecArgs() {
            return this.execArgs;
        }

        public final void setExecArgs(String execArgs) {
            this.execArgs = execArgs;
        }

        @Override
        public final Builder execArgs(String execArgs) {
            this.execArgs = execArgs;
            return this;
        }

        public final String getExecutable() {
            return this.executable;
        }

        public final void setExecutable(String executable) {
            this.executable = executable;
        }

        @Override
        public final Builder executable(String executable) {
            this.executable = executable;
            return this;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final Boolean getPinned() {
            return this.pinned;
        }

        public final void setPinned(Boolean pinned) {
            this.pinned = pinned;
        }

        @Override
        public final Builder pinned(Boolean pinned) {
            this.pinned = pinned;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getFunctionRuntimeOverride() {
            return this.functionRuntimeOverride;
        }

        public final void setFunctionRuntimeOverride(String functionRuntimeOverride) {
            this.functionRuntimeOverride = functionRuntimeOverride;
        }

        @Override
        public final Builder functionRuntimeOverride(String functionRuntimeOverride) {
            this.functionRuntimeOverride = functionRuntimeOverride;
            return this;
        }

        public FunctionConfiguration build() {
            return new FunctionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionConfiguration> {
        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder environment(FunctionConfigurationEnvironment var1);

        default public Builder environment(Consumer<FunctionConfigurationEnvironment.Builder> environment) {
            return this.environment((FunctionConfigurationEnvironment)((FunctionConfigurationEnvironment.Builder)FunctionConfigurationEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder execArgs(String var1);

        public Builder executable(String var1);

        public Builder memorySize(Integer var1);

        public Builder pinned(Boolean var1);

        public Builder timeout(Integer var1);

        public Builder functionRuntimeOverride(String var1);
    }
}

