/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrass.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefinitionInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefinitionInformation> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DefinitionInformation.getter(DefinitionInformation::arn)).setter(DefinitionInformation.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTimestamp").getter(DefinitionInformation.getter(DefinitionInformation::creationTimestamp)).setter(DefinitionInformation.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DefinitionInformation.getter(DefinitionInformation::id)).setter(DefinitionInformation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTimestamp").getter(DefinitionInformation.getter(DefinitionInformation::lastUpdatedTimestamp)).setter(DefinitionInformation.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestVersion").getter(DefinitionInformation.getter(DefinitionInformation::latestVersion)).setter(DefinitionInformation.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()}).build();
    private static final SdkField<String> LATEST_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestVersionArn").getter(DefinitionInformation.getter(DefinitionInformation::latestVersionArn)).setter(DefinitionInformation.setter(Builder::latestVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DefinitionInformation.getter(DefinitionInformation::name)).setter(DefinitionInformation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DefinitionInformation.getter(DefinitionInformation::tags)).setter(DefinitionInformation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIMESTAMP_FIELD, ID_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, LATEST_VERSION_FIELD, LATEST_VERSION_ARN_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String creationTimestamp;
    private final String id;
    private final String lastUpdatedTimestamp;
    private final String latestVersion;
    private final String latestVersionArn;
    private final String name;
    private final Map<String, String> tags;

    private DefinitionInformation(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.id = builder.id;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.latestVersion = builder.latestVersion;
        this.latestVersionArn = builder.latestVersionArn;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationTimestamp() {
        return this.creationTimestamp;
    }

    public final String id() {
        return this.id;
    }

    public final String lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final String latestVersion() {
        return this.latestVersion;
    }

    public final String latestVersionArn() {
        return this.latestVersionArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionInformation)) {
            return false;
        }
        DefinitionInformation other = (DefinitionInformation)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.latestVersionArn(), other.latestVersionArn()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DefinitionInformation").add("Arn", (Object)this.arn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Id", (Object)this.id()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("LatestVersion", (Object)this.latestVersion()).add("LatestVersionArn", (Object)this.latestVersionArn()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "LatestVersionArn": {
                return Optional.ofNullable(clazz.cast(this.latestVersionArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefinitionInformation, T> g) {
        return obj -> g.apply((DefinitionInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String creationTimestamp;
        private String id;
        private String lastUpdatedTimestamp;
        private String latestVersion;
        private String latestVersionArn;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefinitionInformation model) {
            this.arn(model.arn);
            this.creationTimestamp(model.creationTimestamp);
            this.id(model.id);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.latestVersion(model.latestVersion);
            this.latestVersionArn(model.latestVersionArn);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final String getLatestVersionArn() {
            return this.latestVersionArn;
        }

        public final void setLatestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
        }

        @Override
        public final Builder latestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public DefinitionInformation build() {
            return new DefinitionInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefinitionInformation> {
        public Builder arn(String var1);

        public Builder creationTimestamp(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedTimestamp(String var1);

        public Builder latestVersion(String var1);

        public Builder latestVersionArn(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

