/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SoftwareToUpdate {
    CORE("core"),
    OTA_AGENT("ota_agent"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SoftwareToUpdate> VALUE_MAP;
    private final String value;

    private SoftwareToUpdate(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SoftwareToUpdate fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SoftwareToUpdate> knownValues() {
        EnumSet<SoftwareToUpdate> knownValues = EnumSet.allOf(SoftwareToUpdate.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SoftwareToUpdate.class, SoftwareToUpdate::toString);
    }
}

