/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentType {
    NEW_DEPLOYMENT("NewDeployment"),
    REDEPLOYMENT("Redeployment"),
    RESET_DEPLOYMENT("ResetDeployment"),
    FORCE_RESET_DEPLOYMENT("ForceResetDeployment"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentType> VALUE_MAP;
    private final String value;

    private DeploymentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentType> knownValues() {
        EnumSet<DeploymentType> knownValues = EnumSet.allOf(DeploymentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentType.class, DeploymentType::toString);
    }
}

