/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GroupOwnerSetting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalVolumeResourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalVolumeResourceData> {
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPath").getter(LocalVolumeResourceData.getter(LocalVolumeResourceData::destinationPath)).setter(LocalVolumeResourceData.setter(Builder::destinationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()}).build();
    private static final SdkField<GroupOwnerSetting> GROUP_OWNER_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroupOwnerSetting").getter(LocalVolumeResourceData.getter(LocalVolumeResourceData::groupOwnerSetting)).setter(LocalVolumeResourceData.setter(Builder::groupOwnerSetting)).constructor(GroupOwnerSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwnerSetting").build()}).build();
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePath").getter(LocalVolumeResourceData.getter(LocalVolumeResourceData::sourcePath)).setter(LocalVolumeResourceData.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PATH_FIELD, GROUP_OWNER_SETTING_FIELD, SOURCE_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationPath;
    private final GroupOwnerSetting groupOwnerSetting;
    private final String sourcePath;

    private LocalVolumeResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.groupOwnerSetting = builder.groupOwnerSetting;
        this.sourcePath = builder.sourcePath;
    }

    public final String destinationPath() {
        return this.destinationPath;
    }

    public final GroupOwnerSetting groupOwnerSetting() {
        return this.groupOwnerSetting;
    }

    public final String sourcePath() {
        return this.sourcePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupOwnerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalVolumeResourceData)) {
            return false;
        }
        LocalVolumeResourceData other = (LocalVolumeResourceData)obj;
        return Objects.equals(this.destinationPath(), other.destinationPath()) && Objects.equals(this.groupOwnerSetting(), other.groupOwnerSetting()) && Objects.equals(this.sourcePath(), other.sourcePath());
    }

    public final String toString() {
        return ToString.builder((String)"LocalVolumeResourceData").add("DestinationPath", (Object)this.destinationPath()).add("GroupOwnerSetting", (Object)this.groupOwnerSetting()).add("SourcePath", (Object)this.sourcePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
            case "GroupOwnerSetting": {
                return Optional.ofNullable(clazz.cast(this.groupOwnerSetting()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalVolumeResourceData, T> g) {
        return obj -> g.apply((LocalVolumeResourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPath;
        private GroupOwnerSetting groupOwnerSetting;
        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalVolumeResourceData model) {
            this.destinationPath(model.destinationPath);
            this.groupOwnerSetting(model.groupOwnerSetting);
            this.sourcePath(model.sourcePath);
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final GroupOwnerSetting.Builder getGroupOwnerSetting() {
            return this.groupOwnerSetting != null ? this.groupOwnerSetting.toBuilder() : null;
        }

        @Override
        public final Builder groupOwnerSetting(GroupOwnerSetting groupOwnerSetting) {
            this.groupOwnerSetting = groupOwnerSetting;
            return this;
        }

        public final void setGroupOwnerSetting(GroupOwnerSetting.BuilderImpl groupOwnerSetting) {
            this.groupOwnerSetting = groupOwnerSetting != null ? groupOwnerSetting.build() : null;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public LocalVolumeResourceData build() {
            return new LocalVolumeResourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalVolumeResourceData> {
        public Builder destinationPath(String var1);

        public Builder groupOwnerSetting(GroupOwnerSetting var1);

        default public Builder groupOwnerSetting(Consumer<GroupOwnerSetting.Builder> groupOwnerSetting) {
            return this.groupOwnerSetting((GroupOwnerSetting)((GroupOwnerSetting.Builder)GroupOwnerSetting.builder().applyMutation(groupOwnerSetting)).build());
        }

        public Builder sourcePath(String var1);
    }
}

