/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrass.model.BulkDeploymentMetrics;
import software.amazon.awssdk.services.greengrass.model.BulkDeploymentStatus;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.services.greengrass.model.ErrorDetailsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBulkDeploymentStatusResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, GetBulkDeploymentStatusResponse> {
    private static final SdkField<BulkDeploymentMetrics> BULK_DEPLOYMENT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BulkDeploymentMetrics").getter(GetBulkDeploymentStatusResponse.getter(GetBulkDeploymentStatusResponse::bulkDeploymentMetrics)).setter(GetBulkDeploymentStatusResponse.setter(Builder::bulkDeploymentMetrics)).constructor(BulkDeploymentMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentMetrics").build()}).build();
    private static final SdkField<String> BULK_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BulkDeploymentStatus").getter(GetBulkDeploymentStatusResponse.getter(GetBulkDeploymentStatusResponse::bulkDeploymentStatusAsString)).setter(GetBulkDeploymentStatusResponse.setter(Builder::bulkDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentStatus").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(GetBulkDeploymentStatusResponse.getter(GetBulkDeploymentStatusResponse::createdAt)).setter(GetBulkDeploymentStatusResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetails").getter(GetBulkDeploymentStatusResponse.getter(GetBulkDeploymentStatusResponse::errorDetails)).setter(GetBulkDeploymentStatusResponse.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetBulkDeploymentStatusResponse.getter(GetBulkDeploymentStatusResponse::errorMessage)).setter(GetBulkDeploymentStatusResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetBulkDeploymentStatusResponse.getter(GetBulkDeploymentStatusResponse::tags)).setter(GetBulkDeploymentStatusResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENT_METRICS_FIELD, BULK_DEPLOYMENT_STATUS_FIELD, CREATED_AT_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, TAGS_FIELD));
    private final BulkDeploymentMetrics bulkDeploymentMetrics;
    private final String bulkDeploymentStatus;
    private final String createdAt;
    private final List<ErrorDetail> errorDetails;
    private final String errorMessage;
    private final Map<String, String> tags;

    private GetBulkDeploymentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.bulkDeploymentMetrics = builder.bulkDeploymentMetrics;
        this.bulkDeploymentStatus = builder.bulkDeploymentStatus;
        this.createdAt = builder.createdAt;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.tags = builder.tags;
    }

    public BulkDeploymentMetrics bulkDeploymentMetrics() {
        return this.bulkDeploymentMetrics;
    }

    public BulkDeploymentStatus bulkDeploymentStatus() {
        return BulkDeploymentStatus.fromValue(this.bulkDeploymentStatus);
    }

    public String bulkDeploymentStatusAsString() {
        return this.bulkDeploymentStatus;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkDeploymentMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBulkDeploymentStatusResponse)) {
            return false;
        }
        GetBulkDeploymentStatusResponse other = (GetBulkDeploymentStatusResponse)((Object)obj);
        return Objects.equals(this.bulkDeploymentMetrics(), other.bulkDeploymentMetrics()) && Objects.equals(this.bulkDeploymentStatusAsString(), other.bulkDeploymentStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetBulkDeploymentStatusResponse").add("BulkDeploymentMetrics", (Object)this.bulkDeploymentMetrics()).add("BulkDeploymentStatus", (Object)this.bulkDeploymentStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).add("ErrorMessage", (Object)this.errorMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BulkDeploymentMetrics": {
                return Optional.ofNullable(clazz.cast(this.bulkDeploymentMetrics()));
            }
            case "BulkDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.bulkDeploymentStatusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBulkDeploymentStatusResponse, T> g) {
        return obj -> g.apply((GetBulkDeploymentStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private BulkDeploymentMetrics bulkDeploymentMetrics;
        private String bulkDeploymentStatus;
        private String createdAt;
        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBulkDeploymentStatusResponse model) {
            super(model);
            this.bulkDeploymentMetrics(model.bulkDeploymentMetrics);
            this.bulkDeploymentStatus(model.bulkDeploymentStatus);
            this.createdAt(model.createdAt);
            this.errorDetails(model.errorDetails);
            this.errorMessage(model.errorMessage);
            this.tags(model.tags);
        }

        public final BulkDeploymentMetrics.Builder getBulkDeploymentMetrics() {
            return this.bulkDeploymentMetrics != null ? this.bulkDeploymentMetrics.toBuilder() : null;
        }

        @Override
        public final Builder bulkDeploymentMetrics(BulkDeploymentMetrics bulkDeploymentMetrics) {
            this.bulkDeploymentMetrics = bulkDeploymentMetrics;
            return this;
        }

        public final void setBulkDeploymentMetrics(BulkDeploymentMetrics.BuilderImpl bulkDeploymentMetrics) {
            this.bulkDeploymentMetrics = bulkDeploymentMetrics != null ? bulkDeploymentMetrics.build() : null;
        }

        public final String getBulkDeploymentStatus() {
            return this.bulkDeploymentStatus;
        }

        @Override
        public final Builder bulkDeploymentStatus(String bulkDeploymentStatus) {
            this.bulkDeploymentStatus = bulkDeploymentStatus;
            return this;
        }

        @Override
        public final Builder bulkDeploymentStatus(BulkDeploymentStatus bulkDeploymentStatus) {
            this.bulkDeploymentStatus(bulkDeploymentStatus == null ? null : bulkDeploymentStatus.toString());
            return this;
        }

        public final void setBulkDeploymentStatus(String bulkDeploymentStatus) {
            this.bulkDeploymentStatus = bulkDeploymentStatus;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<ErrorDetail.Builder> getErrorDetails() {
            if (this.errorDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errorDetails != null ? (Collection)this.errorDetails.stream().map(ErrorDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public GetBulkDeploymentStatusResponse build() {
            return new GetBulkDeploymentStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBulkDeploymentStatusResponse> {
        public Builder bulkDeploymentMetrics(BulkDeploymentMetrics var1);

        default public Builder bulkDeploymentMetrics(Consumer<BulkDeploymentMetrics.Builder> bulkDeploymentMetrics) {
            return this.bulkDeploymentMetrics((BulkDeploymentMetrics)((BulkDeploymentMetrics.Builder)BulkDeploymentMetrics.builder().applyMutation(bulkDeploymentMetrics)).build());
        }

        public Builder bulkDeploymentStatus(String var1);

        public Builder bulkDeploymentStatus(BulkDeploymentStatus var1);

        public Builder createdAt(String var1);

        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder errorDetails(Consumer<ErrorDetail.Builder> ... var1);

        public Builder errorMessage(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

