/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.services.greengrass.model.ErrorDetailsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BadRequestException
extends GreengrassException
implements ToCopyableBuilder<Builder, BadRequestException> {
    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetails").getter(BadRequestException.getter(BadRequestException::errorDetails)).setter(BadRequestException.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ErrorDetail> errorDetails;

    private BadRequestException(BuilderImpl builder) {
        super(builder);
        this.errorDetails = builder.errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BadRequestException, T> g) {
        return obj -> g.apply((BadRequestException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassException.BuilderImpl
    implements Builder {
        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestException model) {
            super(model);
            this.errorDetails(model.errorDetails);
        }

        public final Collection<ErrorDetail.Builder> getErrorDetails() {
            return this.errorDetails != null ? (Collection)this.errorDetails.stream().map(ErrorDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BadRequestException build() {
            return new BadRequestException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BadRequestException>,
    GreengrassException.Builder {
        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder errorDetails(Consumer<ErrorDetail.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

