/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.FunctionIsolationMode;
import software.amazon.awssdk.services.greengrass.model.FunctionRunAsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionDefaultExecutionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionDefaultExecutionConfig> {
    private static final SdkField<String> ISOLATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsolationMode").getter(FunctionDefaultExecutionConfig.getter(FunctionDefaultExecutionConfig::isolationModeAsString)).setter(FunctionDefaultExecutionConfig.setter(Builder::isolationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolationMode").build()}).build();
    private static final SdkField<FunctionRunAsConfig> RUN_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunAs").getter(FunctionDefaultExecutionConfig.getter(FunctionDefaultExecutionConfig::runAs)).setter(FunctionDefaultExecutionConfig.setter(Builder::runAs)).constructor(FunctionRunAsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISOLATION_MODE_FIELD, RUN_AS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String isolationMode;
    private final FunctionRunAsConfig runAs;

    private FunctionDefaultExecutionConfig(BuilderImpl builder) {
        this.isolationMode = builder.isolationMode;
        this.runAs = builder.runAs;
    }

    public FunctionIsolationMode isolationMode() {
        return FunctionIsolationMode.fromValue(this.isolationMode);
    }

    public String isolationModeAsString() {
        return this.isolationMode;
    }

    public FunctionRunAsConfig runAs() {
        return this.runAs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isolationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runAs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefaultExecutionConfig)) {
            return false;
        }
        FunctionDefaultExecutionConfig other = (FunctionDefaultExecutionConfig)obj;
        return Objects.equals(this.isolationModeAsString(), other.isolationModeAsString()) && Objects.equals(this.runAs(), other.runAs());
    }

    public String toString() {
        return ToString.builder((String)"FunctionDefaultExecutionConfig").add("IsolationMode", (Object)this.isolationModeAsString()).add("RunAs", (Object)this.runAs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsolationMode": {
                return Optional.ofNullable(clazz.cast(this.isolationModeAsString()));
            }
            case "RunAs": {
                return Optional.ofNullable(clazz.cast(this.runAs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionDefaultExecutionConfig, T> g) {
        return obj -> g.apply((FunctionDefaultExecutionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String isolationMode;
        private FunctionRunAsConfig runAs;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefaultExecutionConfig model) {
            this.isolationMode(model.isolationMode);
            this.runAs(model.runAs);
        }

        public final String getIsolationMode() {
            return this.isolationMode;
        }

        @Override
        public final Builder isolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
            return this;
        }

        @Override
        public final Builder isolationMode(FunctionIsolationMode isolationMode) {
            this.isolationMode(isolationMode == null ? null : isolationMode.toString());
            return this;
        }

        public final void setIsolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
        }

        public final FunctionRunAsConfig.Builder getRunAs() {
            return this.runAs != null ? this.runAs.toBuilder() : null;
        }

        @Override
        public final Builder runAs(FunctionRunAsConfig runAs) {
            this.runAs = runAs;
            return this;
        }

        public final void setRunAs(FunctionRunAsConfig.BuilderImpl runAs) {
            this.runAs = runAs != null ? runAs.build() : null;
        }

        public FunctionDefaultExecutionConfig build() {
            return new FunctionDefaultExecutionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionDefaultExecutionConfig> {
        public Builder isolationMode(String var1);

        public Builder isolationMode(FunctionIsolationMode var1);

        public Builder runAs(FunctionRunAsConfig var1);

        default public Builder runAs(Consumer<FunctionRunAsConfig.Builder> runAs) {
            return this.runAs((FunctionRunAsConfig)((FunctionRunAsConfig.Builder)FunctionRunAsConfig.builder().applyMutation(runAs)).build());
        }
    }
}

