/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Telemetry {
    ON("On"),
    OFF("Off"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Telemetry(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Telemetry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Telemetry.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Telemetry> knownValues() {
        return Stream.of(Telemetry.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

