/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.Permission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDownloadOwnerSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDownloadOwnerSetting> {
    private static final SdkField<String> GROUP_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceDownloadOwnerSetting.getter(ResourceDownloadOwnerSetting::groupOwner)).setter(ResourceDownloadOwnerSetting.setter(Builder::groupOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwner").build()}).build();
    private static final SdkField<String> GROUP_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceDownloadOwnerSetting.getter(ResourceDownloadOwnerSetting::groupPermissionAsString)).setter(ResourceDownloadOwnerSetting.setter(Builder::groupPermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupPermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_OWNER_FIELD, GROUP_PERMISSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupOwner;
    private final String groupPermission;

    private ResourceDownloadOwnerSetting(BuilderImpl builder) {
        this.groupOwner = builder.groupOwner;
        this.groupPermission = builder.groupPermission;
    }

    public String groupOwner() {
        return this.groupOwner;
    }

    public Permission groupPermission() {
        return Permission.fromValue(this.groupPermission);
    }

    public String groupPermissionAsString() {
        return this.groupPermission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupPermissionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDownloadOwnerSetting)) {
            return false;
        }
        ResourceDownloadOwnerSetting other = (ResourceDownloadOwnerSetting)obj;
        return Objects.equals(this.groupOwner(), other.groupOwner()) && Objects.equals(this.groupPermissionAsString(), other.groupPermissionAsString());
    }

    public String toString() {
        return ToString.builder((String)"ResourceDownloadOwnerSetting").add("GroupOwner", (Object)this.groupOwner()).add("GroupPermission", (Object)this.groupPermissionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupOwner": {
                return Optional.ofNullable(clazz.cast(this.groupOwner()));
            }
            case "GroupPermission": {
                return Optional.ofNullable(clazz.cast(this.groupPermissionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDownloadOwnerSetting, T> g) {
        return obj -> g.apply((ResourceDownloadOwnerSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupOwner;
        private String groupPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDownloadOwnerSetting model) {
            this.groupOwner(model.groupOwner);
            this.groupPermission(model.groupPermission);
        }

        public final String getGroupOwner() {
            return this.groupOwner;
        }

        @Override
        public final Builder groupOwner(String groupOwner) {
            this.groupOwner = groupOwner;
            return this;
        }

        public final void setGroupOwner(String groupOwner) {
            this.groupOwner = groupOwner;
        }

        public final String getGroupPermission() {
            return this.groupPermission;
        }

        @Override
        public final Builder groupPermission(String groupPermission) {
            this.groupPermission = groupPermission;
            return this;
        }

        @Override
        public final Builder groupPermission(Permission groupPermission) {
            this.groupPermission(groupPermission == null ? null : groupPermission.toString());
            return this;
        }

        public final void setGroupPermission(String groupPermission) {
            this.groupPermission = groupPermission;
        }

        public ResourceDownloadOwnerSetting build() {
            return new ResourceDownloadOwnerSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDownloadOwnerSetting> {
        public Builder groupOwner(String var1);

        public Builder groupPermission(String var1);

        public Builder groupPermission(Permission var1);
    }
}

