/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBulkDeploymentStatusResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetBulkDeploymentStatusResponse.Builder, GetBulkDeploymentStatusResponse> {
    private static final SdkField<BulkDeploymentMetrics> BULK_DEPLOYMENT_METRICS_FIELD = SdkField
            .<BulkDeploymentMetrics> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBulkDeploymentStatusResponse::bulkDeploymentMetrics))
            .setter(setter(Builder::bulkDeploymentMetrics)).constructor(BulkDeploymentMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentMetrics").build())
            .build();

    private static final SdkField<String> BULK_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBulkDeploymentStatusResponse::bulkDeploymentStatusAsString))
            .setter(setter(Builder::bulkDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentStatus").build())
            .build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBulkDeploymentStatusResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .getter(getter(GetBulkDeploymentStatusResponse::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBulkDeploymentStatusResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetBulkDeploymentStatusResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENT_METRICS_FIELD,
            BULK_DEPLOYMENT_STATUS_FIELD, CREATED_AT_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, TAGS_FIELD));

    private final BulkDeploymentMetrics bulkDeploymentMetrics;

    private final String bulkDeploymentStatus;

    private final String createdAt;

    private final List<ErrorDetail> errorDetails;

    private final String errorMessage;

    private final Map<String, String> tags;

    private GetBulkDeploymentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.bulkDeploymentMetrics = builder.bulkDeploymentMetrics;
        this.bulkDeploymentStatus = builder.bulkDeploymentStatus;
        this.createdAt = builder.createdAt;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.tags = builder.tags;
    }

    /**
     * Relevant metrics on input records processed during bulk deployment.
     * 
     * @return Relevant metrics on input records processed during bulk deployment.
     */
    public BulkDeploymentMetrics bulkDeploymentMetrics() {
        return bulkDeploymentMetrics;
    }

    /**
     * The status of the bulk deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #bulkDeploymentStatus} will return {@link BulkDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #bulkDeploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the bulk deployment.
     * @see BulkDeploymentStatus
     */
    public BulkDeploymentStatus bulkDeploymentStatus() {
        return BulkDeploymentStatus.fromValue(bulkDeploymentStatus);
    }

    /**
     * The status of the bulk deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #bulkDeploymentStatus} will return {@link BulkDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #bulkDeploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the bulk deployment.
     * @see BulkDeploymentStatus
     */
    public String bulkDeploymentStatusAsString() {
        return bulkDeploymentStatus;
    }

    /**
     * The time, in ISO format, when the deployment was created.
     * 
     * @return The time, in ISO format, when the deployment was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the ErrorDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrorDetails() {
        return errorDetails != null && !(errorDetails instanceof SdkAutoConstructList);
    }

    /**
     * Error details
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrorDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Error details
     */
    public List<ErrorDetail> errorDetails() {
        return errorDetails;
    }

    /**
     * Error message
     * 
     * @return Error message
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Tag(s) attached to the resource arn.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tag(s) attached to the resource arn.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBulkDeploymentStatusResponse)) {
            return false;
        }
        GetBulkDeploymentStatusResponse other = (GetBulkDeploymentStatusResponse) obj;
        return Objects.equals(bulkDeploymentMetrics(), other.bulkDeploymentMetrics())
                && Objects.equals(bulkDeploymentStatusAsString(), other.bulkDeploymentStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBulkDeploymentStatusResponse").add("BulkDeploymentMetrics", bulkDeploymentMetrics())
                .add("BulkDeploymentStatus", bulkDeploymentStatusAsString()).add("CreatedAt", createdAt())
                .add("ErrorDetails", errorDetails()).add("ErrorMessage", errorMessage()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BulkDeploymentMetrics":
            return Optional.ofNullable(clazz.cast(bulkDeploymentMetrics()));
        case "BulkDeploymentStatus":
            return Optional.ofNullable(clazz.cast(bulkDeploymentStatusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBulkDeploymentStatusResponse, T> g) {
        return obj -> g.apply((GetBulkDeploymentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBulkDeploymentStatusResponse> {
        /**
         * Relevant metrics on input records processed during bulk deployment.
         * 
         * @param bulkDeploymentMetrics
         *        Relevant metrics on input records processed during bulk deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeploymentMetrics(BulkDeploymentMetrics bulkDeploymentMetrics);

        /**
         * Relevant metrics on input records processed during bulk deployment. This is a convenience that creates an
         * instance of the {@link BulkDeploymentMetrics.Builder} avoiding the need to create one manually via
         * {@link BulkDeploymentMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link BulkDeploymentMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #bulkDeploymentMetrics(BulkDeploymentMetrics)}.
         * 
         * @param bulkDeploymentMetrics
         *        a consumer that will call methods on {@link BulkDeploymentMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bulkDeploymentMetrics(BulkDeploymentMetrics)
         */
        default Builder bulkDeploymentMetrics(Consumer<BulkDeploymentMetrics.Builder> bulkDeploymentMetrics) {
            return bulkDeploymentMetrics(BulkDeploymentMetrics.builder().applyMutation(bulkDeploymentMetrics).build());
        }

        /**
         * The status of the bulk deployment.
         * 
         * @param bulkDeploymentStatus
         *        The status of the bulk deployment.
         * @see BulkDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BulkDeploymentStatus
         */
        Builder bulkDeploymentStatus(String bulkDeploymentStatus);

        /**
         * The status of the bulk deployment.
         * 
         * @param bulkDeploymentStatus
         *        The status of the bulk deployment.
         * @see BulkDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BulkDeploymentStatus
         */
        Builder bulkDeploymentStatus(BulkDeploymentStatus bulkDeploymentStatus);

        /**
         * The time, in ISO format, when the deployment was created.
         * 
         * @param createdAt
         *        The time, in ISO format, when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * Error details
         * 
         * @param errorDetails
         *        Error details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(Collection<ErrorDetail> errorDetails);

        /**
         * Error details
         * 
         * @param errorDetails
         *        Error details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetail... errorDetails);

        /**
         * Error details This is a convenience that creates an instance of the {@link List<ErrorDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ErrorDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ErrorDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(List<ErrorDetail>)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link List<ErrorDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(List<ErrorDetail>)
         */
        Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails);

        /**
         * Error message
         * 
         * @param errorMessage
         *        Error message
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * Tag(s) attached to the resource arn.
         * 
         * @param tags
         *        Tag(s) attached to the resource arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private BulkDeploymentMetrics bulkDeploymentMetrics;

        private String bulkDeploymentStatus;

        private String createdAt;

        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBulkDeploymentStatusResponse model) {
            super(model);
            bulkDeploymentMetrics(model.bulkDeploymentMetrics);
            bulkDeploymentStatus(model.bulkDeploymentStatus);
            createdAt(model.createdAt);
            errorDetails(model.errorDetails);
            errorMessage(model.errorMessage);
            tags(model.tags);
        }

        public final BulkDeploymentMetrics.Builder getBulkDeploymentMetrics() {
            return bulkDeploymentMetrics != null ? bulkDeploymentMetrics.toBuilder() : null;
        }

        @Override
        public final Builder bulkDeploymentMetrics(BulkDeploymentMetrics bulkDeploymentMetrics) {
            this.bulkDeploymentMetrics = bulkDeploymentMetrics;
            return this;
        }

        public final void setBulkDeploymentMetrics(BulkDeploymentMetrics.BuilderImpl bulkDeploymentMetrics) {
            this.bulkDeploymentMetrics = bulkDeploymentMetrics != null ? bulkDeploymentMetrics.build() : null;
        }

        public final String getBulkDeploymentStatus() {
            return bulkDeploymentStatus;
        }

        @Override
        public final Builder bulkDeploymentStatus(String bulkDeploymentStatus) {
            this.bulkDeploymentStatus = bulkDeploymentStatus;
            return this;
        }

        @Override
        public final Builder bulkDeploymentStatus(BulkDeploymentStatus bulkDeploymentStatus) {
            this.bulkDeploymentStatus(bulkDeploymentStatus == null ? null : bulkDeploymentStatus.toString());
            return this;
        }

        public final void setBulkDeploymentStatus(String bulkDeploymentStatus) {
            this.bulkDeploymentStatus = bulkDeploymentStatus;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<ErrorDetail.Builder> getErrorDetails() {
            return errorDetails != null ? errorDetails.stream().map(ErrorDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail... errorDetails) {
            errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails) {
            errorDetails(Stream.of(errorDetails).map(c -> ErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public GetBulkDeploymentStatusResponse build() {
            return new GetBulkDeploymentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
