/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The default configuration that applies to all Lambda functions in the group. Individual Lambda functions can override
 * these settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionDefaultConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionDefaultConfig.Builder, FunctionDefaultConfig> {
    private static final SdkField<FunctionDefaultExecutionConfig> EXECUTION_FIELD = SdkField
            .<FunctionDefaultExecutionConfig> builder(MarshallingType.SDK_POJO).getter(getter(FunctionDefaultConfig::execution))
            .setter(setter(Builder::execution)).constructor(FunctionDefaultExecutionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Execution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FunctionDefaultExecutionConfig execution;

    private FunctionDefaultConfig(BuilderImpl builder) {
        this.execution = builder.execution;
    }

    /**
     * Returns the value of the Execution property for this object.
     * 
     * @return The value of the Execution property for this object.
     */
    public FunctionDefaultExecutionConfig execution() {
        return execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefaultConfig)) {
            return false;
        }
        FunctionDefaultConfig other = (FunctionDefaultConfig) obj;
        return Objects.equals(execution(), other.execution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FunctionDefaultConfig").add("Execution", execution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Execution":
            return Optional.ofNullable(clazz.cast(execution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionDefaultConfig, T> g) {
        return obj -> g.apply((FunctionDefaultConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionDefaultConfig> {
        /**
         * Sets the value of the Execution property for this object.
         *
         * @param execution
         *        The new value for the Execution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(FunctionDefaultExecutionConfig execution);

        /**
         * Sets the value of the Execution property for this object.
         *
         * This is a convenience that creates an instance of the {@link FunctionDefaultExecutionConfig.Builder} avoiding
         * the need to create one manually via {@link FunctionDefaultExecutionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionDefaultExecutionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #execution(FunctionDefaultExecutionConfig)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link FunctionDefaultExecutionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(FunctionDefaultExecutionConfig)
         */
        default Builder execution(Consumer<FunctionDefaultExecutionConfig.Builder> execution) {
            return execution(FunctionDefaultExecutionConfig.builder().applyMutation(execution).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FunctionDefaultExecutionConfig execution;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefaultConfig model) {
            execution(model.execution);
        }

        public final FunctionDefaultExecutionConfig.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        @Override
        public final Builder execution(FunctionDefaultExecutionConfig execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(FunctionDefaultExecutionConfig.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public FunctionDefaultConfig build() {
            return new FunctionDefaultConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
