/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that define a secret resource, which references a secret from AWS Secrets Manager. AWS IoT Greengrass
 * stores a local, encrypted copy of the secret on the Greengrass core, where it can be securely accessed by connectors
 * and Lambda functions.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecretsManagerSecretResourceData implements SdkPojo, Serializable,
        ToCopyableBuilder<SecretsManagerSecretResourceData.Builder, SecretsManagerSecretResourceData> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SecretsManagerSecretResourceData::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SecretsManagerSecretResourceData::additionalStagingLabelsToDownload))
            .setter(setter(Builder::additionalStagingLabelsToDownload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalStagingLabelsToDownload")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> additionalStagingLabelsToDownload;

    private SecretsManagerSecretResourceData(BuilderImpl builder) {
        this.arn = builder.arn;
        this.additionalStagingLabelsToDownload = builder.additionalStagingLabelsToDownload;
    }

    /**
     * The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version
     * (represented by the ''AWSCURRENT'' staging label) is included by default.
     * 
     * @return The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest
     *         version (represented by the ''AWSCURRENT'' staging label) is included by default.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the AdditionalStagingLabelsToDownload property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasAdditionalStagingLabelsToDownload() {
        return additionalStagingLabelsToDownload != null && !(additionalStagingLabelsToDownload instanceof SdkAutoConstructList);
    }

    /**
     * Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalStagingLabelsToDownload()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional. The staging labels whose values you want to make available on the core, in addition to
     *         ''AWSCURRENT''.
     */
    public List<String> additionalStagingLabelsToDownload() {
        return additionalStagingLabelsToDownload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(additionalStagingLabelsToDownload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretsManagerSecretResourceData)) {
            return false;
        }
        SecretsManagerSecretResourceData other = (SecretsManagerSecretResourceData) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(additionalStagingLabelsToDownload(), other.additionalStagingLabelsToDownload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SecretsManagerSecretResourceData").add("ARN", arn())
                .add("AdditionalStagingLabelsToDownload", additionalStagingLabelsToDownload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AdditionalStagingLabelsToDownload":
            return Optional.ofNullable(clazz.cast(additionalStagingLabelsToDownload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecretsManagerSecretResourceData, T> g) {
        return obj -> g.apply((SecretsManagerSecretResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecretsManagerSecretResourceData> {
        /**
         * The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version
         * (represented by the ''AWSCURRENT'' staging label) is included by default.
         * 
         * @param arn
         *        The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest
         *        version (represented by the ''AWSCURRENT'' staging label) is included by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Optional. The staging labels whose values you want to make available on the core, in addition to
         * ''AWSCURRENT''.
         * 
         * @param additionalStagingLabelsToDownload
         *        Optional. The staging labels whose values you want to make available on the core, in addition to
         *        ''AWSCURRENT''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload);

        /**
         * Optional. The staging labels whose values you want to make available on the core, in addition to
         * ''AWSCURRENT''.
         * 
         * @param additionalStagingLabelsToDownload
         *        Optional. The staging labels whose values you want to make available on the core, in addition to
         *        ''AWSCURRENT''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalStagingLabelsToDownload(String... additionalStagingLabelsToDownload);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> additionalStagingLabelsToDownload = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecretsManagerSecretResourceData model) {
            arn(model.arn);
            additionalStagingLabelsToDownload(model.additionalStagingLabelsToDownload);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getAdditionalStagingLabelsToDownload() {
            return additionalStagingLabelsToDownload;
        }

        @Override
        public final Builder additionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload = ___listOf__stringCopier.copy(additionalStagingLabelsToDownload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalStagingLabelsToDownload(String... additionalStagingLabelsToDownload) {
            additionalStagingLabelsToDownload(Arrays.asList(additionalStagingLabelsToDownload));
            return this;
        }

        public final void setAdditionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload = ___listOf__stringCopier.copy(additionalStagingLabelsToDownload);
        }

        @Override
        public SecretsManagerSecretResourceData build() {
            return new SecretsManagerSecretResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
