/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that define a local volume resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalVolumeResourceData implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalVolumeResourceData.Builder, LocalVolumeResourceData> {
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LocalVolumeResourceData::destinationPath)).setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()).build();

    private static final SdkField<GroupOwnerSetting> GROUP_OWNER_SETTING_FIELD = SdkField
            .<GroupOwnerSetting> builder(MarshallingType.SDK_POJO).getter(getter(LocalVolumeResourceData::groupOwnerSetting))
            .setter(setter(Builder::groupOwnerSetting)).constructor(GroupOwnerSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwnerSetting").build()).build();

    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LocalVolumeResourceData::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PATH_FIELD,
            GROUP_OWNER_SETTING_FIELD, SOURCE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationPath;

    private final GroupOwnerSetting groupOwnerSetting;

    private final String sourcePath;

    private LocalVolumeResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.groupOwnerSetting = builder.groupOwnerSetting;
        this.sourcePath = builder.sourcePath;
    }

    /**
     * The absolute local path of the resource inside the Lambda environment.
     * 
     * @return The absolute local path of the resource inside the Lambda environment.
     */
    public String destinationPath() {
        return destinationPath;
    }

    /**
     * Allows you to configure additional group privileges for the Lambda process. This field is optional.
     * 
     * @return Allows you to configure additional group privileges for the Lambda process. This field is optional.
     */
    public GroupOwnerSetting groupOwnerSetting() {
        return groupOwnerSetting;
    }

    /**
     * The local absolute path of the volume resource on the host. The source path for a volume resource type cannot
     * start with ''/sys''.
     * 
     * @return The local absolute path of the volume resource on the host. The source path for a volume resource type
     *         cannot start with ''/sys''.
     */
    public String sourcePath() {
        return sourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(groupOwnerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalVolumeResourceData)) {
            return false;
        }
        LocalVolumeResourceData other = (LocalVolumeResourceData) obj;
        return Objects.equals(destinationPath(), other.destinationPath())
                && Objects.equals(groupOwnerSetting(), other.groupOwnerSetting())
                && Objects.equals(sourcePath(), other.sourcePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalVolumeResourceData").add("DestinationPath", destinationPath())
                .add("GroupOwnerSetting", groupOwnerSetting()).add("SourcePath", sourcePath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        case "GroupOwnerSetting":
            return Optional.ofNullable(clazz.cast(groupOwnerSetting()));
        case "SourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalVolumeResourceData, T> g) {
        return obj -> g.apply((LocalVolumeResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalVolumeResourceData> {
        /**
         * The absolute local path of the resource inside the Lambda environment.
         * 
         * @param destinationPath
         *        The absolute local path of the resource inside the Lambda environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);

        /**
         * Allows you to configure additional group privileges for the Lambda process. This field is optional.
         * 
         * @param groupOwnerSetting
         *        Allows you to configure additional group privileges for the Lambda process. This field is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOwnerSetting(GroupOwnerSetting groupOwnerSetting);

        /**
         * Allows you to configure additional group privileges for the Lambda process. This field is optional. This is a
         * convenience that creates an instance of the {@link GroupOwnerSetting.Builder} avoiding the need to create one
         * manually via {@link GroupOwnerSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroupOwnerSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #groupOwnerSetting(GroupOwnerSetting)}.
         * 
         * @param groupOwnerSetting
         *        a consumer that will call methods on {@link GroupOwnerSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupOwnerSetting(GroupOwnerSetting)
         */
        default Builder groupOwnerSetting(Consumer<GroupOwnerSetting.Builder> groupOwnerSetting) {
            return groupOwnerSetting(GroupOwnerSetting.builder().applyMutation(groupOwnerSetting).build());
        }

        /**
         * The local absolute path of the volume resource on the host. The source path for a volume resource type cannot
         * start with ''/sys''.
         * 
         * @param sourcePath
         *        The local absolute path of the volume resource on the host. The source path for a volume resource type
         *        cannot start with ''/sys''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);
    }

    static final class BuilderImpl implements Builder {
        private String destinationPath;

        private GroupOwnerSetting groupOwnerSetting;

        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalVolumeResourceData model) {
            destinationPath(model.destinationPath);
            groupOwnerSetting(model.groupOwnerSetting);
            sourcePath(model.sourcePath);
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final GroupOwnerSetting.Builder getGroupOwnerSetting() {
            return groupOwnerSetting != null ? groupOwnerSetting.toBuilder() : null;
        }

        @Override
        public final Builder groupOwnerSetting(GroupOwnerSetting groupOwnerSetting) {
            this.groupOwnerSetting = groupOwnerSetting;
            return this;
        }

        public final void setGroupOwnerSetting(GroupOwnerSetting.BuilderImpl groupOwnerSetting) {
            this.groupOwnerSetting = groupOwnerSetting != null ? groupOwnerSetting.build() : null;
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public LocalVolumeResourceData build() {
            return new LocalVolumeResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
