/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoreDefinitionVersionsRequest extends GreengrassRequest implements
        ToCopyableBuilder<ListCoreDefinitionVersionsRequest.Builder, ListCoreDefinitionVersionsRequest> {
    private static final SdkField<String> CORE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCoreDefinitionVersionsRequest::coreDefinitionId)).setter(setter(Builder::coreDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CoreDefinitionId").build()).build();

    private static final SdkField<String> MAX_RESULTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCoreDefinitionVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCoreDefinitionVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEFINITION_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String coreDefinitionId;

    private final String maxResults;

    private final String nextToken;

    private ListCoreDefinitionVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.coreDefinitionId = builder.coreDefinitionId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * The ID of the core definition.
     * 
     * @return The ID of the core definition.
     */
    public String coreDefinitionId() {
        return coreDefinitionId;
    }

    /**
     * The maximum number of results to be returned per request.
     * 
     * @return The maximum number of results to be returned per request.
     */
    public String maxResults() {
        return maxResults;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreDefinitionVersionsRequest)) {
            return false;
        }
        ListCoreDefinitionVersionsRequest other = (ListCoreDefinitionVersionsRequest) obj;
        return Objects.equals(coreDefinitionId(), other.coreDefinitionId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCoreDefinitionVersionsRequest").add("CoreDefinitionId", coreDefinitionId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreDefinitionId":
            return Optional.ofNullable(clazz.cast(coreDefinitionId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoreDefinitionVersionsRequest, T> g) {
        return obj -> g.apply((ListCoreDefinitionVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCoreDefinitionVersionsRequest> {
        /**
         * The ID of the core definition.
         * 
         * @param coreDefinitionId
         *        The ID of the core definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDefinitionId(String coreDefinitionId);

        /**
         * The maximum number of results to be returned per request.
         * 
         * @param maxResults
         *        The maximum number of results to be returned per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(String maxResults);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String coreDefinitionId;

        private String maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreDefinitionVersionsRequest model) {
            super(model);
            coreDefinitionId(model.coreDefinitionId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCoreDefinitionId() {
            return coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        public final String getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCoreDefinitionVersionsRequest build() {
            return new ListCoreDefinitionVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
