/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSubscriptionDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<DeleteSubscriptionDefinitionRequest.Builder, DeleteSubscriptionDefinitionRequest> {
    private static final SdkField<String> SUBSCRIPTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSubscriptionDefinitionRequest::subscriptionDefinitionId))
            .setter(setter(Builder::subscriptionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscriptionDefinitionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUBSCRIPTION_DEFINITION_ID_FIELD));

    private final String subscriptionDefinitionId;

    private DeleteSubscriptionDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionDefinitionId = builder.subscriptionDefinitionId;
    }

    /**
     * The ID of the subscription definition.
     * 
     * @return The ID of the subscription definition.
     */
    public String subscriptionDefinitionId() {
        return subscriptionDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionDefinitionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubscriptionDefinitionRequest)) {
            return false;
        }
        DeleteSubscriptionDefinitionRequest other = (DeleteSubscriptionDefinitionRequest) obj;
        return Objects.equals(subscriptionDefinitionId(), other.subscriptionDefinitionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteSubscriptionDefinitionRequest")
                .add("SubscriptionDefinitionId", subscriptionDefinitionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionDefinitionId":
            return Optional.ofNullable(clazz.cast(subscriptionDefinitionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSubscriptionDefinitionRequest, T> g) {
        return obj -> g.apply((DeleteSubscriptionDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteSubscriptionDefinitionRequest> {
        /**
         * The ID of the subscription definition.
         * 
         * @param subscriptionDefinitionId
         *        The ID of the subscription definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionDefinitionId(String subscriptionDefinitionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String subscriptionDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubscriptionDefinitionRequest model) {
            super(model);
            subscriptionDefinitionId(model.subscriptionDefinitionId);
        }

        public final String getSubscriptionDefinitionId() {
            return subscriptionDefinitionId;
        }

        @Override
        public final Builder subscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        public final void setSubscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSubscriptionDefinitionRequest build() {
            return new DeleteSubscriptionDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
