/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupCertificateAuthorityResponse extends GreengrassResponse implements
        ToCopyableBuilder<CreateGroupCertificateAuthorityResponse.Builder, CreateGroupCertificateAuthorityResponse> {
    private static final SdkField<String> GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGroupCertificateAuthorityResponse::groupCertificateAuthorityArn))
            .setter(setter(Builder::groupCertificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupCertificateAuthorityArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD));

    private final String groupCertificateAuthorityArn;

    private CreateGroupCertificateAuthorityResponse(BuilderImpl builder) {
        super(builder);
        this.groupCertificateAuthorityArn = builder.groupCertificateAuthorityArn;
    }

    /**
     * The ARN of the group certificate authority.
     * 
     * @return The ARN of the group certificate authority.
     */
    public String groupCertificateAuthorityArn() {
        return groupCertificateAuthorityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupCertificateAuthorityArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupCertificateAuthorityResponse)) {
            return false;
        }
        CreateGroupCertificateAuthorityResponse other = (CreateGroupCertificateAuthorityResponse) obj;
        return Objects.equals(groupCertificateAuthorityArn(), other.groupCertificateAuthorityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGroupCertificateAuthorityResponse")
                .add("GroupCertificateAuthorityArn", groupCertificateAuthorityArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupCertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(groupCertificateAuthorityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupCertificateAuthorityResponse, T> g) {
        return obj -> g.apply((CreateGroupCertificateAuthorityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGroupCertificateAuthorityResponse> {
        /**
         * The ARN of the group certificate authority.
         * 
         * @param groupCertificateAuthorityArn
         *        The ARN of the group certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorityArn(String groupCertificateAuthorityArn);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String groupCertificateAuthorityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupCertificateAuthorityResponse model) {
            super(model);
            groupCertificateAuthorityArn(model.groupCertificateAuthorityArn);
        }

        public final String getGroupCertificateAuthorityArn() {
            return groupCertificateAuthorityArn;
        }

        @Override
        public final Builder groupCertificateAuthorityArn(String groupCertificateAuthorityArn) {
            this.groupCertificateAuthorityArn = groupCertificateAuthorityArn;
            return this;
        }

        public final void setGroupCertificateAuthorityArn(String groupCertificateAuthorityArn) {
            this.groupCertificateAuthorityArn = groupCertificateAuthorityArn;
        }

        @Override
        public CreateGroupCertificateAuthorityResponse build() {
            return new CreateGroupCertificateAuthorityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
