/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a connector. Connectors run on the Greengrass core and contain built-in integration with local
 * infrastructure, device protocols, AWS, and other cloud services.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connector implements SdkPojo, Serializable, ToCopyableBuilder<Connector.Builder, Connector> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connector::connectorArn)).setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connector::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Connector::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, ID_FIELD,
            PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorArn;

    private final String id;

    private final Map<String, String> parameters;

    private Connector(BuilderImpl builder) {
        this.connectorArn = builder.connectorArn;
        this.id = builder.id;
        this.parameters = builder.parameters;
    }

    /**
     * The ARN of the connector.
     * 
     * @return The ARN of the connector.
     */
    public String connectorArn() {
        return connectorArn;
    }

    /**
     * A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition
     * version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
     * 
     * @return A descriptive or arbitrary ID for the connector. This value must be unique within the connector
     *         definition version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
     */
    public String id() {
        return id;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * The parameters or configuration that the connector uses.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters or configuration that the connector uses.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector) obj;
        return Objects.equals(connectorArn(), other.connectorArn()) && Objects.equals(id(), other.id())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Connector").add("ConnectorArn", connectorArn()).add("Id", id()).add("Parameters", parameters())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connector, T> g) {
        return obj -> g.apply((Connector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connector> {
        /**
         * The ARN of the connector.
         * 
         * @param connectorArn
         *        The ARN of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition
         * version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
         * 
         * @param id
         *        A descriptive or arbitrary ID for the connector. This value must be unique within the connector
         *        definition version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The parameters or configuration that the connector uses.
         * 
         * @param parameters
         *        The parameters or configuration that the connector uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String connectorArn;

        private String id;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Connector model) {
            connectorArn(model.connectorArn);
            id(model.id);
            parameters(model.parameters);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ___mapOf__stringCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ___mapOf__stringCopier.copy(parameters);
        }

        @Override
        public Connector build() {
            return new Connector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
