/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a Greengrass core's connectivity.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectivityInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectivityInfo.Builder, ConnectivityInfo> {
    private static final SdkField<String> HOST_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectivityInfo::hostAddress)).setter(setter(Builder::hostAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostAddress").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectivityInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectivityInfo::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Integer> PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ConnectivityInfo::portNumber)).setter(setter(Builder::portNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ADDRESS_FIELD, ID_FIELD,
            METADATA_FIELD, PORT_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostAddress;

    private final String id;

    private final String metadata;

    private final Integer portNumber;

    private ConnectivityInfo(BuilderImpl builder) {
        this.hostAddress = builder.hostAddress;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.portNumber = builder.portNumber;
    }

    /**
     * The endpoint for the Greengrass core. Can be an IP address or DNS.
     * 
     * @return The endpoint for the Greengrass core. Can be an IP address or DNS.
     */
    public String hostAddress() {
        return hostAddress;
    }

    /**
     * The ID of the connectivity information.
     * 
     * @return The ID of the connectivity information.
     */
    public String id() {
        return id;
    }

    /**
     * Metadata for this endpoint.
     * 
     * @return Metadata for this endpoint.
     */
    public String metadata() {
        return metadata;
    }

    /**
     * The port of the Greengrass core. Usually 8883.
     * 
     * @return The port of the Greengrass core. Usually 8883.
     */
    public Integer portNumber() {
        return portNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(portNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo) obj;
        return Objects.equals(hostAddress(), other.hostAddress()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(portNumber(), other.portNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectivityInfo").add("HostAddress", hostAddress()).add("Id", id()).add("Metadata", metadata())
                .add("PortNumber", portNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostAddress":
            return Optional.ofNullable(clazz.cast(hostAddress()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "PortNumber":
            return Optional.ofNullable(clazz.cast(portNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectivityInfo, T> g) {
        return obj -> g.apply((ConnectivityInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectivityInfo> {
        /**
         * The endpoint for the Greengrass core. Can be an IP address or DNS.
         * 
         * @param hostAddress
         *        The endpoint for the Greengrass core. Can be an IP address or DNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostAddress(String hostAddress);

        /**
         * The ID of the connectivity information.
         * 
         * @param id
         *        The ID of the connectivity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Metadata for this endpoint.
         * 
         * @param metadata
         *        Metadata for this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * The port of the Greengrass core. Usually 8883.
         * 
         * @param portNumber
         *        The port of the Greengrass core. Usually 8883.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portNumber(Integer portNumber);
    }

    static final class BuilderImpl implements Builder {
        private String hostAddress;

        private String id;

        private String metadata;

        private Integer portNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            hostAddress(model.hostAddress);
            id(model.id);
            metadata(model.metadata);
            portNumber(model.portNumber);
        }

        public final String getHostAddress() {
            return hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Integer getPortNumber() {
            return portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        @Override
        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
