/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.greengrass.model.Deployment;

public class DeploymentUnmarshaller
implements Unmarshaller<Deployment, JsonUnmarshallerContext> {
    private static final DeploymentUnmarshaller INSTANCE = new DeploymentUnmarshaller();

    public Deployment unmarshall(JsonUnmarshallerContext context) throws Exception {
        Deployment.Builder deploymentBuilder = Deployment.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    deploymentBuilder.createdAt((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeploymentArn", targetDepth)) {
                    context.nextToken();
                    deploymentBuilder.deploymentArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeploymentId", targetDepth)) {
                    context.nextToken();
                    deploymentBuilder.deploymentId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeploymentType", targetDepth)) {
                    context.nextToken();
                    deploymentBuilder.deploymentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("GroupArn", targetDepth)) {
                    context.nextToken();
                    deploymentBuilder.groupArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Deployment)deploymentBuilder.build();
    }

    public static DeploymentUnmarshaller getInstance() {
        return INSTANCE;
    }
}

