/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.ListOfVersionInformationCopier;
import software.amazon.awssdk.services.greengrass.model.VersionInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGroupVersionsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListGroupVersionsResponse> {
    private final String nextToken;
    private final List<VersionInformation> versions;

    private ListGroupVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.versions = builder.versions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VersionInformation> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupVersionsResponse)) {
            return false;
        }
        ListGroupVersionsResponse other = (ListGroupVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.versions(), other.versions());
    }

    public String toString() {
        return ToString.builder((String)"ListGroupVersionsResponse").add("NextToken", (Object)this.nextToken()).add("Versions", this.versions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Versions": {
                return Optional.of(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VersionInformation> versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupVersionsResponse model) {
            this.nextToken(model.nextToken);
            this.versions(model.versions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VersionInformation.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(VersionInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<VersionInformation> versions) {
            this.versions = ListOfVersionInformationCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(VersionInformation ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<VersionInformation.BuilderImpl> versions) {
            this.versions = ListOfVersionInformationCopier.copyFromBuilder(versions);
        }

        @Override
        public ListGroupVersionsResponse build() {
            return new ListGroupVersionsResponse(this);
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    CopyableBuilder<Builder, ListGroupVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder versions(Collection<VersionInformation> var1);

        public Builder versions(VersionInformation ... var1);
    }
}

