/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.Device;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfDeviceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeviceDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateDeviceDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String deviceDefinitionId;
    private final List<Device> devices;

    private CreateDeviceDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.deviceDefinitionId = builder.deviceDefinitionId;
        this.devices = builder.devices;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String deviceDefinitionId() {
        return this.deviceDefinitionId;
    }

    public List<Device> devices() {
        return this.devices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.devices());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceDefinitionVersionRequest)) {
            return false;
        }
        CreateDeviceDefinitionVersionRequest other = (CreateDeviceDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.deviceDefinitionId(), other.deviceDefinitionId()) && Objects.equals(this.devices(), other.devices());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeviceDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("DeviceDefinitionId", (Object)this.deviceDefinitionId()).add("Devices", this.devices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "DeviceDefinitionId": {
                return Optional.of(clazz.cast(this.deviceDefinitionId()));
            }
            case "Devices": {
                return Optional.of(clazz.cast(this.devices()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String deviceDefinitionId;
        private List<Device> devices;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceDefinitionVersionRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.deviceDefinitionId(model.deviceDefinitionId);
            this.devices(model.devices);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getDeviceDefinitionId() {
            return this.deviceDefinitionId;
        }

        @Override
        public final Builder deviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        public final void setDeviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
        }

        public final Collection<Device.Builder> getDevices() {
            return this.devices != null ? (Collection)this.devices.stream().map(Device::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = ListOfDeviceCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = ListOfDeviceCopier.copyFromBuilder(devices);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDeviceDefinitionVersionRequest build() {
            return new CreateDeviceDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateDeviceDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder deviceDefinitionId(String var1);

        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

