/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Core;
import software.amazon.awssdk.services.greengrass.model.ListOfCoreCopier;
import software.amazon.awssdk.services.greengrass.transform.CoreDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CoreDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, CoreDefinitionVersion> {
    private final List<Core> cores;

    private CoreDefinitionVersion(BuilderImpl builder) {
        this.cores = builder.cores;
    }

    public List<Core> cores() {
        return this.cores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cores());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreDefinitionVersion)) {
            return false;
        }
        CoreDefinitionVersion other = (CoreDefinitionVersion)obj;
        return Objects.equals(this.cores(), other.cores());
    }

    public String toString() {
        return ToString.builder((String)"CoreDefinitionVersion").add("Cores", this.cores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cores": {
                return Optional.of(clazz.cast(this.cores()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CoreDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Core> cores;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreDefinitionVersion model) {
            this.cores(model.cores);
        }

        public final Collection<Core.Builder> getCores() {
            return this.cores != null ? (Collection)this.cores.stream().map(Core::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ListOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core ... cores) {
            this.cores(Arrays.asList(cores));
            return this;
        }

        public final void setCores(Collection<Core.BuilderImpl> cores) {
            this.cores = ListOfCoreCopier.copyFromBuilder(cores);
        }

        public CoreDefinitionVersion build() {
            return new CoreDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CoreDefinitionVersion> {
        public Builder cores(Collection<Core> var1);

        public Builder cores(Core ... var1);
    }
}

