/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.ConnectivityInfo;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfConnectivityInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConnectivityInfoRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
    private final List<ConnectivityInfo> connectivityInfo;
    private final String thingName;

    private UpdateConnectivityInfoRequest(BuilderImpl builder) {
        super(builder);
        this.connectivityInfo = builder.connectivityInfo;
        this.thingName = builder.thingName;
    }

    public List<ConnectivityInfo> connectivityInfo() {
        return this.connectivityInfo;
    }

    public String thingName() {
        return this.thingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectivityInfoRequest)) {
            return false;
        }
        UpdateConnectivityInfoRequest other = (UpdateConnectivityInfoRequest)((Object)obj);
        return Objects.equals(this.connectivityInfo(), other.connectivityInfo()) && Objects.equals(this.thingName(), other.thingName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConnectivityInfoRequest").add("ConnectivityInfo", this.connectivityInfo()).add("ThingName", (Object)this.thingName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectivityInfo": {
                return Optional.of(clazz.cast(this.connectivityInfo()));
            }
            case "ThingName": {
                return Optional.of(clazz.cast(this.thingName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private List<ConnectivityInfo> connectivityInfo;
        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectivityInfoRequest model) {
            this.connectivityInfo(model.connectivityInfo);
            this.thingName(model.thingName);
        }

        public final Collection<ConnectivityInfo.Builder> getConnectivityInfo() {
            return this.connectivityInfo != null ? (Collection)this.connectivityInfo.stream().map(ConnectivityInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = ListOfConnectivityInfoCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo ... connectivityInfo) {
            this.connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo.BuilderImpl> connectivityInfo) {
            this.connectivityInfo = ListOfConnectivityInfoCopier.copyFromBuilder(connectivityInfo);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectivityInfoRequest build() {
            return new UpdateConnectivityInfoRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
        public Builder connectivityInfo(Collection<ConnectivityInfo> var1);

        public Builder connectivityInfo(ConnectivityInfo ... var1);

        public Builder thingName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

