/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCoreDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, GetCoreDefinitionVersionRequest> {
    private final String coreDefinitionId;
    private final String coreDefinitionVersionId;

    private GetCoreDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.coreDefinitionId = builder.coreDefinitionId;
        this.coreDefinitionVersionId = builder.coreDefinitionVersionId;
    }

    public String coreDefinitionId() {
        return this.coreDefinitionId;
    }

    public String coreDefinitionVersionId() {
        return this.coreDefinitionVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDefinitionVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreDefinitionVersionRequest)) {
            return false;
        }
        GetCoreDefinitionVersionRequest other = (GetCoreDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.coreDefinitionId(), other.coreDefinitionId()) && Objects.equals(this.coreDefinitionVersionId(), other.coreDefinitionVersionId());
    }

    public String toString() {
        return ToString.builder((String)"GetCoreDefinitionVersionRequest").add("CoreDefinitionId", (Object)this.coreDefinitionId()).add("CoreDefinitionVersionId", (Object)this.coreDefinitionVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreDefinitionId": {
                return Optional.of(clazz.cast(this.coreDefinitionId()));
            }
            case "CoreDefinitionVersionId": {
                return Optional.of(clazz.cast(this.coreDefinitionVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String coreDefinitionId;
        private String coreDefinitionVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreDefinitionVersionRequest model) {
            this.coreDefinitionId(model.coreDefinitionId);
            this.coreDefinitionVersionId(model.coreDefinitionVersionId);
        }

        public final String getCoreDefinitionId() {
            return this.coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        public final String getCoreDefinitionVersionId() {
            return this.coreDefinitionVersionId;
        }

        @Override
        public final Builder coreDefinitionVersionId(String coreDefinitionVersionId) {
            this.coreDefinitionVersionId = coreDefinitionVersionId;
            return this;
        }

        public final void setCoreDefinitionVersionId(String coreDefinitionVersionId) {
            this.coreDefinitionVersionId = coreDefinitionVersionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetCoreDefinitionVersionRequest build() {
            return new GetCoreDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, GetCoreDefinitionVersionRequest> {
        public Builder coreDefinitionId(String var1);

        public Builder coreDefinitionVersionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

