/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGroupVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateGroupVersionRequest> {
    private final String amznClientToken;
    private final String coreDefinitionVersionArn;
    private final String deviceDefinitionVersionArn;
    private final String functionDefinitionVersionArn;
    private final String groupId;
    private final String loggerDefinitionVersionArn;
    private final String subscriptionDefinitionVersionArn;

    private CreateGroupVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.coreDefinitionVersionArn = builder.coreDefinitionVersionArn;
        this.deviceDefinitionVersionArn = builder.deviceDefinitionVersionArn;
        this.functionDefinitionVersionArn = builder.functionDefinitionVersionArn;
        this.groupId = builder.groupId;
        this.loggerDefinitionVersionArn = builder.loggerDefinitionVersionArn;
        this.subscriptionDefinitionVersionArn = builder.subscriptionDefinitionVersionArn;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String coreDefinitionVersionArn() {
        return this.coreDefinitionVersionArn;
    }

    public String deviceDefinitionVersionArn() {
        return this.deviceDefinitionVersionArn;
    }

    public String functionDefinitionVersionArn() {
        return this.functionDefinitionVersionArn;
    }

    public String groupId() {
        return this.groupId;
    }

    public String loggerDefinitionVersionArn() {
        return this.loggerDefinitionVersionArn;
    }

    public String subscriptionDefinitionVersionArn() {
        return this.subscriptionDefinitionVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDefinitionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDefinitionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggerDefinitionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionDefinitionVersionArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupVersionRequest)) {
            return false;
        }
        CreateGroupVersionRequest other = (CreateGroupVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.coreDefinitionVersionArn(), other.coreDefinitionVersionArn()) && Objects.equals(this.deviceDefinitionVersionArn(), other.deviceDefinitionVersionArn()) && Objects.equals(this.functionDefinitionVersionArn(), other.functionDefinitionVersionArn()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.loggerDefinitionVersionArn(), other.loggerDefinitionVersionArn()) && Objects.equals(this.subscriptionDefinitionVersionArn(), other.subscriptionDefinitionVersionArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateGroupVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("CoreDefinitionVersionArn", (Object)this.coreDefinitionVersionArn()).add("DeviceDefinitionVersionArn", (Object)this.deviceDefinitionVersionArn()).add("FunctionDefinitionVersionArn", (Object)this.functionDefinitionVersionArn()).add("GroupId", (Object)this.groupId()).add("LoggerDefinitionVersionArn", (Object)this.loggerDefinitionVersionArn()).add("SubscriptionDefinitionVersionArn", (Object)this.subscriptionDefinitionVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "CoreDefinitionVersionArn": {
                return Optional.of(clazz.cast(this.coreDefinitionVersionArn()));
            }
            case "DeviceDefinitionVersionArn": {
                return Optional.of(clazz.cast(this.deviceDefinitionVersionArn()));
            }
            case "FunctionDefinitionVersionArn": {
                return Optional.of(clazz.cast(this.functionDefinitionVersionArn()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "LoggerDefinitionVersionArn": {
                return Optional.of(clazz.cast(this.loggerDefinitionVersionArn()));
            }
            case "SubscriptionDefinitionVersionArn": {
                return Optional.of(clazz.cast(this.subscriptionDefinitionVersionArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String coreDefinitionVersionArn;
        private String deviceDefinitionVersionArn;
        private String functionDefinitionVersionArn;
        private String groupId;
        private String loggerDefinitionVersionArn;
        private String subscriptionDefinitionVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupVersionRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.coreDefinitionVersionArn(model.coreDefinitionVersionArn);
            this.deviceDefinitionVersionArn(model.deviceDefinitionVersionArn);
            this.functionDefinitionVersionArn(model.functionDefinitionVersionArn);
            this.groupId(model.groupId);
            this.loggerDefinitionVersionArn(model.loggerDefinitionVersionArn);
            this.subscriptionDefinitionVersionArn(model.subscriptionDefinitionVersionArn);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getCoreDefinitionVersionArn() {
            return this.coreDefinitionVersionArn;
        }

        @Override
        public final Builder coreDefinitionVersionArn(String coreDefinitionVersionArn) {
            this.coreDefinitionVersionArn = coreDefinitionVersionArn;
            return this;
        }

        public final void setCoreDefinitionVersionArn(String coreDefinitionVersionArn) {
            this.coreDefinitionVersionArn = coreDefinitionVersionArn;
        }

        public final String getDeviceDefinitionVersionArn() {
            return this.deviceDefinitionVersionArn;
        }

        @Override
        public final Builder deviceDefinitionVersionArn(String deviceDefinitionVersionArn) {
            this.deviceDefinitionVersionArn = deviceDefinitionVersionArn;
            return this;
        }

        public final void setDeviceDefinitionVersionArn(String deviceDefinitionVersionArn) {
            this.deviceDefinitionVersionArn = deviceDefinitionVersionArn;
        }

        public final String getFunctionDefinitionVersionArn() {
            return this.functionDefinitionVersionArn;
        }

        @Override
        public final Builder functionDefinitionVersionArn(String functionDefinitionVersionArn) {
            this.functionDefinitionVersionArn = functionDefinitionVersionArn;
            return this;
        }

        public final void setFunctionDefinitionVersionArn(String functionDefinitionVersionArn) {
            this.functionDefinitionVersionArn = functionDefinitionVersionArn;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getLoggerDefinitionVersionArn() {
            return this.loggerDefinitionVersionArn;
        }

        @Override
        public final Builder loggerDefinitionVersionArn(String loggerDefinitionVersionArn) {
            this.loggerDefinitionVersionArn = loggerDefinitionVersionArn;
            return this;
        }

        public final void setLoggerDefinitionVersionArn(String loggerDefinitionVersionArn) {
            this.loggerDefinitionVersionArn = loggerDefinitionVersionArn;
        }

        public final String getSubscriptionDefinitionVersionArn() {
            return this.subscriptionDefinitionVersionArn;
        }

        @Override
        public final Builder subscriptionDefinitionVersionArn(String subscriptionDefinitionVersionArn) {
            this.subscriptionDefinitionVersionArn = subscriptionDefinitionVersionArn;
            return this;
        }

        public final void setSubscriptionDefinitionVersionArn(String subscriptionDefinitionVersionArn) {
            this.subscriptionDefinitionVersionArn = subscriptionDefinitionVersionArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupVersionRequest build() {
            return new CreateGroupVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateGroupVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder coreDefinitionVersionArn(String var1);

        public Builder deviceDefinitionVersionArn(String var1);

        public Builder functionDefinitionVersionArn(String var1);

        public Builder groupId(String var1);

        public Builder loggerDefinitionVersionArn(String var1);

        public Builder subscriptionDefinitionVersionArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

