/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFunctionDefinitionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, UpdateFunctionDefinitionRequest> {
    private final String functionDefinitionId;
    private final String name;

    private UpdateFunctionDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.functionDefinitionId = builder.functionDefinitionId;
        this.name = builder.name;
    }

    public String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionDefinitionRequest)) {
            return false;
        }
        UpdateFunctionDefinitionRequest other = (UpdateFunctionDefinitionRequest)((Object)obj);
        return Objects.equals(this.functionDefinitionId(), other.functionDefinitionId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionDefinitionId() != null) {
            sb.append("FunctionDefinitionId: ").append(this.functionDefinitionId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionDefinitionId": {
                return Optional.of(clazz.cast(this.functionDefinitionId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String functionDefinitionId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionDefinitionRequest model) {
            this.functionDefinitionId(model.functionDefinitionId);
            this.name(model.name);
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionDefinitionRequest build() {
            return new UpdateFunctionDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, UpdateFunctionDefinitionRequest> {
        public Builder functionDefinitionId(String var1);

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

