/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.FunctionConfigurationEnvironment;
import software.amazon.awssdk.services.greengrass.transform.FunctionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FunctionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionConfiguration> {
    private final FunctionConfigurationEnvironment environment;
    private final String execArgs;
    private final String executable;
    private final Integer memorySize;
    private final Boolean pinned;
    private final Integer timeout;

    private FunctionConfiguration(BuilderImpl builder) {
        this.environment = builder.environment;
        this.execArgs = builder.execArgs;
        this.executable = builder.executable;
        this.memorySize = builder.memorySize;
        this.pinned = builder.pinned;
        this.timeout = builder.timeout;
    }

    public FunctionConfigurationEnvironment environment() {
        return this.environment;
    }

    public String execArgs() {
        return this.execArgs;
    }

    public String executable() {
        return this.executable;
    }

    public Integer memorySize() {
        return this.memorySize;
    }

    public Boolean pinned() {
        return this.pinned;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.execArgs());
        hashCode = 31 * hashCode + Objects.hashCode(this.executable());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinned());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfiguration)) {
            return false;
        }
        FunctionConfiguration other = (FunctionConfiguration)obj;
        return Objects.equals(this.environment(), other.environment()) && Objects.equals(this.execArgs(), other.execArgs()) && Objects.equals(this.executable(), other.executable()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.pinned(), other.pinned()) && Objects.equals(this.timeout(), other.timeout());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.execArgs() != null) {
            sb.append("ExecArgs: ").append(this.execArgs()).append(",");
        }
        if (this.executable() != null) {
            sb.append("Executable: ").append(this.executable()).append(",");
        }
        if (this.memorySize() != null) {
            sb.append("MemorySize: ").append(this.memorySize()).append(",");
        }
        if (this.pinned() != null) {
            sb.append("Pinned: ").append(this.pinned()).append(",");
        }
        if (this.timeout() != null) {
            sb.append("Timeout: ").append(this.timeout()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
            case "ExecArgs": {
                return Optional.of(clazz.cast(this.execArgs()));
            }
            case "Executable": {
                return Optional.of(clazz.cast(this.executable()));
            }
            case "MemorySize": {
                return Optional.of(clazz.cast(this.memorySize()));
            }
            case "Pinned": {
                return Optional.of(clazz.cast(this.pinned()));
            }
            case "Timeout": {
                return Optional.of(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private FunctionConfigurationEnvironment environment;
        private String execArgs;
        private String executable;
        private Integer memorySize;
        private Boolean pinned;
        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfiguration model) {
            this.environment(model.environment);
            this.execArgs(model.execArgs);
            this.executable(model.executable);
            this.memorySize(model.memorySize);
            this.pinned(model.pinned);
            this.timeout(model.timeout);
        }

        public final FunctionConfigurationEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(FunctionConfigurationEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(FunctionConfigurationEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getExecArgs() {
            return this.execArgs;
        }

        @Override
        public final Builder execArgs(String execArgs) {
            this.execArgs = execArgs;
            return this;
        }

        public final void setExecArgs(String execArgs) {
            this.execArgs = execArgs;
        }

        public final String getExecutable() {
            return this.executable;
        }

        @Override
        public final Builder executable(String executable) {
            this.executable = executable;
            return this;
        }

        public final void setExecutable(String executable) {
            this.executable = executable;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final Boolean getPinned() {
            return this.pinned;
        }

        @Override
        public final Builder pinned(Boolean pinned) {
            this.pinned = pinned;
            return this;
        }

        public final void setPinned(Boolean pinned) {
            this.pinned = pinned;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public FunctionConfiguration build() {
            return new FunctionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionConfiguration> {
        public Builder environment(FunctionConfigurationEnvironment var1);

        default public Builder environment(Consumer<FunctionConfigurationEnvironment.Builder> environment) {
            return this.environment((FunctionConfigurationEnvironment)((FunctionConfigurationEnvironment.Builder)FunctionConfigurationEnvironment.builder().apply(environment)).build());
        }

        public Builder execArgs(String var1);

        public Builder executable(String var1);

        public Builder memorySize(Integer var1);

        public Builder pinned(Boolean var1);

        public Builder timeout(Integer var1);
    }
}

