/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Device;
import software.amazon.awssdk.services.greengrass.model.ListOfDeviceCopier;
import software.amazon.awssdk.services.greengrass.transform.DeviceDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeviceDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceDefinitionVersion> {
    private final List<Device> devices;

    private DeviceDefinitionVersion(BuilderImpl builder) {
        this.devices = builder.devices;
    }

    public List<Device> devices() {
        return this.devices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devices());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDefinitionVersion)) {
            return false;
        }
        DeviceDefinitionVersion other = (DeviceDefinitionVersion)obj;
        return Objects.equals(this.devices(), other.devices());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.devices() != null) {
            sb.append("Devices: ").append(this.devices()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Devices": {
                return Optional.of(clazz.cast(this.devices()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Device> devices;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDefinitionVersion model) {
            this.devices(model.devices);
        }

        public final Collection<Device.Builder> getDevices() {
            return this.devices != null ? (Collection)this.devices.stream().map(Device::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = ListOfDeviceCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = ListOfDeviceCopier.copyFromBuilder(devices);
        }

        public DeviceDefinitionVersion build() {
            return new DeviceDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceDefinitionVersion> {
        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);
    }
}

