/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFunctionDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetFunctionDefinitionVersionRequest> {
    private final String functionDefinitionId;
    private final String functionDefinitionVersionId;

    private GetFunctionDefinitionVersionRequest(BuilderImpl builder) {
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functionDefinitionVersionId = builder.functionDefinitionVersionId;
    }

    public String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public String functionDefinitionVersionId() {
        return this.functionDefinitionVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionDefinitionVersionRequest)) {
            return false;
        }
        GetFunctionDefinitionVersionRequest other = (GetFunctionDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.functionDefinitionId(), other.functionDefinitionId()) && Objects.equals(this.functionDefinitionVersionId(), other.functionDefinitionVersionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionDefinitionId() != null) {
            sb.append("FunctionDefinitionId: ").append(this.functionDefinitionId()).append(",");
        }
        if (this.functionDefinitionVersionId() != null) {
            sb.append("FunctionDefinitionVersionId: ").append(this.functionDefinitionVersionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionDefinitionId": {
                return Optional.of(clazz.cast(this.functionDefinitionId()));
            }
            case "FunctionDefinitionVersionId": {
                return Optional.of(clazz.cast(this.functionDefinitionVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionDefinitionId;
        private String functionDefinitionVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionDefinitionVersionRequest model) {
            this.functionDefinitionId(model.functionDefinitionId);
            this.functionDefinitionVersionId(model.functionDefinitionVersionId);
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final String getFunctionDefinitionVersionId() {
            return this.functionDefinitionVersionId;
        }

        @Override
        public final Builder functionDefinitionVersionId(String functionDefinitionVersionId) {
            this.functionDefinitionVersionId = functionDefinitionVersionId;
            return this;
        }

        public final void setFunctionDefinitionVersionId(String functionDefinitionVersionId) {
            this.functionDefinitionVersionId = functionDefinitionVersionId;
        }

        public GetFunctionDefinitionVersionRequest build() {
            return new GetFunctionDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFunctionDefinitionVersionRequest> {
        public Builder functionDefinitionId(String var1);

        public Builder functionDefinitionVersionId(String var1);
    }
}

