/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfSubscriptionCopier;
import software.amazon.awssdk.services.greengrass.model.Subscription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSubscriptionDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String subscriptionDefinitionId;
    private final List<Subscription> subscriptions;

    private CreateSubscriptionDefinitionVersionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.subscriptionDefinitionId = builder.subscriptionDefinitionId;
        this.subscriptions = builder.subscriptions;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String subscriptionDefinitionId() {
        return this.subscriptionDefinitionId;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionDefinitionVersionRequest)) {
            return false;
        }
        CreateSubscriptionDefinitionVersionRequest other = (CreateSubscriptionDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.subscriptionDefinitionId(), other.subscriptionDefinitionId()) && Objects.equals(this.subscriptions(), other.subscriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.subscriptionDefinitionId() != null) {
            sb.append("SubscriptionDefinitionId: ").append(this.subscriptionDefinitionId()).append(",");
        }
        if (this.subscriptions() != null) {
            sb.append("Subscriptions: ").append(this.subscriptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "SubscriptionDefinitionId": {
                return Optional.of(clazz.cast(this.subscriptionDefinitionId()));
            }
            case "Subscriptions": {
                return Optional.of(clazz.cast(this.subscriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String subscriptionDefinitionId;
        private List<Subscription> subscriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionDefinitionVersionRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.subscriptionDefinitionId(model.subscriptionDefinitionId);
            this.subscriptions(model.subscriptions);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getSubscriptionDefinitionId() {
            return this.subscriptionDefinitionId;
        }

        @Override
        public final Builder subscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        public final void setSubscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return this.subscriptions != null ? (Collection)this.subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copyFromBuilder(subscriptions);
        }

        public CreateSubscriptionDefinitionVersionRequest build() {
            return new CreateSubscriptionDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder subscriptionDefinitionId(String var1);

        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);
    }
}

