/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.FunctionDefinitionVersion;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFunctionDefinitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFunctionDefinitionRequest> {
    private final String amznClientToken;
    private final FunctionDefinitionVersion initialVersion;
    private final String name;

    private CreateFunctionDefinitionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.initialVersion = builder.initialVersion;
        this.name = builder.name;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public FunctionDefinitionVersion initialVersion() {
        return this.initialVersion;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionDefinitionRequest)) {
            return false;
        }
        CreateFunctionDefinitionRequest other = (CreateFunctionDefinitionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.initialVersion(), other.initialVersion()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.initialVersion() != null) {
            sb.append("InitialVersion: ").append(this.initialVersion()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "InitialVersion": {
                return Optional.of(clazz.cast(this.initialVersion()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private FunctionDefinitionVersion initialVersion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionDefinitionRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.initialVersion(model.initialVersion);
            this.name(model.name);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final FunctionDefinitionVersion.Builder getInitialVersion() {
            return this.initialVersion != null ? this.initialVersion.toBuilder() : null;
        }

        @Override
        public final Builder initialVersion(FunctionDefinitionVersion initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        public final void setInitialVersion(FunctionDefinitionVersion.BuilderImpl initialVersion) {
            this.initialVersion = initialVersion != null ? initialVersion.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public CreateFunctionDefinitionRequest build() {
            return new CreateFunctionDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFunctionDefinitionRequest> {
        public Builder amznClientToken(String var1);

        public Builder initialVersion(FunctionDefinitionVersion var1);

        default public Builder initialVersion(Consumer<FunctionDefinitionVersion.Builder> initialVersion) {
            return this.initialVersion((FunctionDefinitionVersion)((FunctionDefinitionVersion.Builder)FunctionDefinitionVersion.builder().apply(initialVersion)).build());
        }

        public Builder name(String var1);
    }
}

