/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateRoleToGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateRoleToGroupRequest> {
    private final String groupId;
    private final String roleArn;

    private AssociateRoleToGroupRequest(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.roleArn = builder.roleArn;
    }

    public String groupId() {
        return this.groupId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRoleToGroupRequest)) {
            return false;
        }
        AssociateRoleToGroupRequest other = (AssociateRoleToGroupRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRoleToGroupRequest model) {
            this.groupId(model.groupId);
            this.roleArn(model.roleArn);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public AssociateRoleToGroupRequest build() {
            return new AssociateRoleToGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateRoleToGroupRequest> {
        public Builder groupId(String var1);

        public Builder roleArn(String var1);
    }
}

