/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.ListOfLoggerCopier;
import software.amazon.awssdk.services.greengrass.model.Logger;
import software.amazon.awssdk.services.greengrass.transform.LoggerDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoggerDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, LoggerDefinitionVersion> {
    private final List<Logger> loggers;

    private LoggerDefinitionVersion(BuilderImpl builder) {
        this.loggers = builder.loggers;
    }

    public List<Logger> loggers() {
        return this.loggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loggers() == null ? 0 : this.loggers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggerDefinitionVersion)) {
            return false;
        }
        LoggerDefinitionVersion other = (LoggerDefinitionVersion)obj;
        if (other.loggers() == null ^ this.loggers() == null) {
            return false;
        }
        return other.loggers() == null || other.loggers().equals(this.loggers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loggers() != null) {
            sb.append("Loggers: ").append(this.loggers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Loggers": {
                return Optional.of(clazz.cast(this.loggers()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggerDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Logger> loggers;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggerDefinitionVersion model) {
            this.loggers(model.loggers);
        }

        public final Collection<Logger.Builder> getLoggers() {
            return this.loggers != null ? (Collection)this.loggers.stream().map(Logger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loggers(Collection<Logger> loggers) {
            this.loggers = ListOfLoggerCopier.copy(loggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Logger ... loggers) {
            this.loggers(Arrays.asList(loggers));
            return this;
        }

        public final void setLoggers(Collection<Logger.BuilderImpl> loggers) {
            this.loggers = ListOfLoggerCopier.copyFromBuilder(loggers);
        }

        public LoggerDefinitionVersion build() {
            return new LoggerDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggerDefinitionVersion> {
        public Builder loggers(Collection<Logger> var1);

        public Builder loggers(Logger ... var1);
    }
}

