/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.LoggerComponent;
import software.amazon.awssdk.services.greengrass.model.LoggerLevel;
import software.amazon.awssdk.services.greengrass.model.LoggerType;
import software.amazon.awssdk.services.greengrass.transform.LoggerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Logger
implements StructuredPojo,
ToCopyableBuilder<Builder, Logger> {
    private final String component;
    private final String id;
    private final String level;
    private final Integer space;
    private final String type;

    private Logger(BuilderImpl builder) {
        this.component = builder.component;
        this.id = builder.id;
        this.level = builder.level;
        this.space = builder.space;
        this.type = builder.type;
    }

    public LoggerComponent component() {
        return LoggerComponent.fromValue(this.component);
    }

    public String componentString() {
        return this.component;
    }

    public String id() {
        return this.id;
    }

    public LoggerLevel level() {
        return LoggerLevel.fromValue(this.level);
    }

    public String levelString() {
        return this.level;
    }

    public Integer space() {
        return this.space;
    }

    public LoggerType type() {
        return LoggerType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.componentString() == null ? 0 : this.componentString().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.levelString() == null ? 0 : this.levelString().hashCode());
        hashCode = 31 * hashCode + (this.space() == null ? 0 : this.space().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logger)) {
            return false;
        }
        Logger other = (Logger)obj;
        if (other.componentString() == null ^ this.componentString() == null) {
            return false;
        }
        if (other.componentString() != null && !other.componentString().equals(this.componentString())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.levelString() == null ^ this.levelString() == null) {
            return false;
        }
        if (other.levelString() != null && !other.levelString().equals(this.levelString())) {
            return false;
        }
        if (other.space() == null ^ this.space() == null) {
            return false;
        }
        if (other.space() != null && !other.space().equals(this.space())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        return other.typeString() == null || other.typeString().equals(this.typeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.componentString() != null) {
            sb.append("Component: ").append(this.componentString()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.levelString() != null) {
            sb.append("Level: ").append(this.levelString()).append(",");
        }
        if (this.space() != null) {
            sb.append("Space: ").append(this.space()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Component": {
                return Optional.of(clazz.cast(this.componentString()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Level": {
                return Optional.of(clazz.cast(this.levelString()));
            }
            case "Space": {
                return Optional.of(clazz.cast(this.space()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String component;
        private String id;
        private String level;
        private Integer space;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Logger model) {
            this.component(model.component);
            this.id(model.id);
            this.level(model.level);
            this.space(model.space);
            this.type(model.type);
        }

        public final String getComponent() {
            return this.component;
        }

        @Override
        public final Builder component(String component) {
            this.component = component;
            return this;
        }

        @Override
        public final Builder component(LoggerComponent component) {
            this.component(component.toString());
            return this;
        }

        public final void setComponent(String component) {
            this.component = component;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLevel() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggerLevel level) {
            this.level(level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Integer getSpace() {
            return this.space;
        }

        @Override
        public final Builder space(Integer space) {
            this.space = space;
            return this;
        }

        public final void setSpace(Integer space) {
            this.space = space;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoggerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Logger build() {
            return new Logger(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Logger> {
        public Builder component(String var1);

        public Builder component(LoggerComponent var1);

        public Builder id(String var1);

        public Builder level(String var1);

        public Builder level(LoggerLevel var1);

        public Builder space(Integer var1);

        public Builder type(String var1);

        public Builder type(LoggerType var1);
    }
}

