/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.greengrass.model.ConnectivityInfo;
import software.amazon.awssdk.services.greengrass.model.ListOfConnectivityInfoCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetConnectivityInfoResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetConnectivityInfoResponse> {
    private final List<ConnectivityInfo> connectivityInfo;
    private final String message;

    private GetConnectivityInfoResponse(BuilderImpl builder) {
        this.connectivityInfo = builder.connectivityInfo;
        this.message = builder.message;
    }

    public List<ConnectivityInfo> connectivityInfo() {
        return this.connectivityInfo;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectivityInfo() == null ? 0 : this.connectivityInfo().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectivityInfoResponse)) {
            return false;
        }
        GetConnectivityInfoResponse other = (GetConnectivityInfoResponse)((Object)obj);
        if (other.connectivityInfo() == null ^ this.connectivityInfo() == null) {
            return false;
        }
        if (other.connectivityInfo() != null && !other.connectivityInfo().equals(this.connectivityInfo())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        return other.message() == null || other.message().equals(this.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connectivityInfo() != null) {
            sb.append("ConnectivityInfo: ").append(this.connectivityInfo()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectivityInfo": {
                return Optional.of(clazz.cast(this.connectivityInfo()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ConnectivityInfo> connectivityInfo;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectivityInfoResponse model) {
            this.connectivityInfo(model.connectivityInfo);
            this.message(model.message);
        }

        public final Collection<ConnectivityInfo.Builder> getConnectivityInfo() {
            return this.connectivityInfo != null ? (Collection)this.connectivityInfo.stream().map(ConnectivityInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = ListOfConnectivityInfoCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo ... connectivityInfo) {
            this.connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo.BuilderImpl> connectivityInfo) {
            this.connectivityInfo = ListOfConnectivityInfoCopier.copyFromBuilder(connectivityInfo);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public GetConnectivityInfoResponse build() {
            return new GetConnectivityInfoResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetConnectivityInfoResponse> {
        public Builder connectivityInfo(Collection<ConnectivityInfo> var1);

        public Builder connectivityInfo(ConnectivityInfo ... var1);

        public Builder message(String var1);
    }
}

