/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.greengrass.model.DefinitionInformation;
import software.amazon.awssdk.services.greengrass.model.ListOfDefinitionInformationCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeviceDefinitionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDeviceDefinitionsResponse> {
    private final List<DefinitionInformation> definitions;
    private final String nextToken;

    private ListDeviceDefinitionsResponse(BuilderImpl builder) {
        this.definitions = builder.definitions;
        this.nextToken = builder.nextToken;
    }

    public List<DefinitionInformation> definitions() {
        return this.definitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.definitions() == null ? 0 : this.definitions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceDefinitionsResponse)) {
            return false;
        }
        ListDeviceDefinitionsResponse other = (ListDeviceDefinitionsResponse)((Object)obj);
        if (other.definitions() == null ^ this.definitions() == null) {
            return false;
        }
        if (other.definitions() != null && !other.definitions().equals(this.definitions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.definitions() != null) {
            sb.append("Definitions: ").append(this.definitions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DefinitionInformation> definitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceDefinitionsResponse model) {
            this.setDefinitions(model.definitions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<DefinitionInformation> getDefinitions() {
            return this.definitions;
        }

        @Override
        public final Builder definitions(Collection<DefinitionInformation> definitions) {
            this.definitions = ListOfDefinitionInformationCopier.copy(definitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(DefinitionInformation ... definitions) {
            this.definitions(Arrays.asList(definitions));
            return this;
        }

        public final void setDefinitions(Collection<DefinitionInformation> definitions) {
            this.definitions = ListOfDefinitionInformationCopier.copy(definitions);
        }

        @SafeVarargs
        public final void setDefinitions(DefinitionInformation ... definitions) {
            this.definitions(Arrays.asList(definitions));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDeviceDefinitionsResponse build() {
            return new ListDeviceDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeviceDefinitionsResponse> {
        public Builder definitions(Collection<DefinitionInformation> var1);

        public Builder definitions(DefinitionInformation ... var1);

        public Builder nextToken(String var1);
    }
}

